/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStructureFactory
implements DataStructureFactory,
Serializable {
    protected ILits lits = new Lits();
    private final IVec<Propagatable> tmp = new Vec<Propagatable>();
    protected UnitPropagationListener solver;
    protected Learner learner;

    @Override
    public void conflictDetectedInWatchesFor(int n, int n2) {
        for (int i = n2 + 1; i < this.tmp.size(); ++i) {
            this.lits.watch(n, this.tmp.get(i));
        }
    }

    @Override
    public IVec<Propagatable> getWatchesFor(int n) {
        this.tmp.clear();
        this.lits.watches(n).moveTo(this.tmp);
        return this.tmp;
    }

    @Override
    public ILits getVocabulary() {
        return this.lits;
    }

    @Override
    public void setUnitPropagationListener(UnitPropagationListener unitPropagationListener) {
        this.solver = unitPropagationListener;
    }

    @Override
    public void setLearner(Learner learner) {
        this.learner = learner;
    }

    @Override
    public void reset() {
        WLClause.resetIds();
    }

    @Override
    public void learnContraint(Constr constr) {
        this.learner.learn(constr);
    }

    @Override
    public Constr createCardinalityConstraint(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Constr createPseudoBooleanConstraint(IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Constr createUnregisteredPseudoBooleanConstraint(IVecInt iVecInt, IVecInt iVecInt2, int n) {
        throw new UnsupportedOperationException();
    }
}

