/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class DimacsReader
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    private int expectedNbOfClauses;
    private final ISolver solver;

    public DimacsReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    protected void skipComments(LineNumberReader lineNumberReader) throws IOException {
        int n;
        do {
            lineNumberReader.mark(4);
            n = lineNumberReader.read();
            if (n == 99) {
                lineNumberReader.readLine();
                continue;
            }
            lineNumberReader.reset();
        } while (n == 99);
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("cnf"))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        assert (n > 0);
        this.solver.newVar(n);
        this.expectedNbOfClauses = Integer.parseInt(stringTokenizer.nextToken());
        assert (this.expectedNbOfClauses > 0);
    }

    /*
     * Unable to fully structure code
     */
    protected void readClauses(LineNumberReader var1_1) throws IOException, ParseFormatException, ContradictionException {
        var5_2 = 0;
        var6_3 = new VecInt();
        block0: while (true) {
            if ((var3_5 = var1_1.readLine()) == null) {
                if (var6_3.size() <= 0) break;
                this.solver.addClause(var6_3);
                ++var5_2;
                break;
            }
            if (var3_5.startsWith("c ")) {
                System.out.println("Found commmented line : " + var3_5);
                continue;
            }
            if (var3_5.startsWith("%") && this.expectedNbOfClauses == var5_2) {
                System.out.println("Ignoring the rest of the file (SATLIB format");
                break;
            }
            var4_6 = new Scanner(var3_5);
            while (true) {
                if (var4_6.hasNext()) ** break;
                continue block0;
                var2_4 = var4_6.nextInt();
                if (var2_4 != 0) {
                    var6_3.push(var2_4);
                    continue;
                }
                if (var6_3.size() <= 0) continue;
                this.solver.addClause(var6_3);
                var6_3.clear();
                ++var5_2;
            }
            break;
        }
        if (this.expectedNbOfClauses != var5_2) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + var5_2 + ", " + this.expectedNbOfClauses + " expected");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void readConstrs(LineNumberReader var1_1) throws IOException, ParseFormatException, ContradictionException {
        var5_2 = 0;
        var6_3 = new VecInt();
        block0: while (true) {
            if ((var3_5 = var1_1.readLine()) == null) {
                if (var6_3.size() <= 0) break;
                this.solver.addClause(var6_3);
                ++var5_2;
                break;
            }
            if (var3_5.startsWith("c ")) continue;
            if (var3_5.startsWith("%") && this.expectedNbOfClauses == var5_2) {
                System.out.println("Ignoring the rest of the file (SATLIB format");
                break;
            }
            var4_6 = new StringTokenizer(var3_5);
            while (true) {
                if (var4_6.hasMoreTokens()) ** break;
                continue block0;
                var7_7 = var4_6.nextToken();
                if (var7_7.equals("<=") || var7_7.equals(">=")) {
                    this.readCardinalityConstr(var7_7, var4_6, var6_3);
                    var6_3.clear();
                    ++var5_2;
                    continue;
                }
                var2_4 = Integer.parseInt(var7_7);
                if (var2_4 != 0) {
                    var6_3.push(var2_4);
                    continue;
                }
                if (var6_3.size() <= 0) continue;
                this.solver.addClause(var6_3);
                var6_3.clear();
                ++var5_2;
            }
            break;
        }
        if (this.expectedNbOfClauses != var5_2) {
            throw new ParseFormatException("wrong nbclauses parameter. Found " + var5_2 + ", " + this.expectedNbOfClauses + " expected");
        }
    }

    private void readCardinalityConstr(String string, StringTokenizer stringTokenizer, IVecInt iVecInt) throws ContradictionException, ParseFormatException {
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        if (n2 == 0) {
            if (string.equals("<=")) {
                this.solver.addAtMost(iVecInt, n);
            } else if (string.equals(">=")) {
                this.solver.addAtLeast(iVecInt, n);
            }
        } else {
            throw new ParseFormatException();
        }
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        FileInputStream fileInputStream;
        InputStream inputStream = fileInputStream = new FileInputStream(string);
        FileChannel fileChannel = fileInputStream.getChannel();
        fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        if (string.endsWith(".gz")) {
            inputStream = new GZIPInputStream(fileInputStream);
        }
        this.parseInstance(new LineNumberReader(new InputStreamReader(inputStream)));
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.skipComments(lineNumberReader);
            this.readProblemLine(lineNumberReader);
            this.readConstrs(lineNumberReader);
        }
        catch (IOException iOException) {
            throw new ParseFormatException(iOException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("0");
        return stringBuffer.toString();
    }
}

