/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;

public class GoodOPBReader
implements Reader,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMENT_SYMBOL = "*";
    private ISolver solver;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVec<String> decode = new Vec<String>();

    public GoodOPBReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        if (string.endsWith(".gz")) {
            this.parseInstance(new LineNumberReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(string)))));
        } else {
            this.parseInstance(new LineNumberReader(new FileReader(string)));
        }
        return this.solver;
    }

    public void parseInstance(LineNumberReader lineNumberReader) throws ContradictionException, IOException {
        String string;
        this.solver.reset();
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            this.parseLine(string);
        }
    }

    void parseLine(String string) throws ContradictionException {
        if (string.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (string.startsWith("p")) {
            return;
        }
        if (string.startsWith("min:") || string.startsWith("min :")) {
            return;
        }
        if (string.startsWith("max:") || string.startsWith("max :")) {
            return;
        }
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        VecInt vecInt = new VecInt();
        VecInt vecInt2 = new VecInt();
        Scanner scanner = new Scanner(string);
        while (scanner.hasNext()) {
            int n2;
            String string2 = scanner.next();
            if (string2.equals(">=") || string2.equals("<=") || string2.equals("=")) {
                assert (scanner.hasNext());
                n2 = scanner.nextInt();
                if (string2.equals(">=") || string2.equals("=")) {
                    this.solver.addPseudoBoolean(vecInt, vecInt2, true, n2);
                }
                if (!string2.equals("<=") && !string2.equals("=")) continue;
                this.solver.addPseudoBoolean(vecInt, vecInt2, false, n2);
                continue;
            }
            if (string2.equals("+")) {
                assert (scanner.hasNext());
                string2 = scanner.next();
            } else if (string2.equals("-")) {
                assert (scanner.hasNext());
                string2 = string2 + scanner.next();
            }
            try {
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                n2 = Integer.parseInt(string2);
                assert (scanner.hasNext());
                string2 = scanner.next();
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
            if (string2.equals("+") || string2.equals("-") || string2.equals("~")) {
                assert (scanner.hasNext());
                string2 = string2 + scanner.next();
            }
            boolean bl = false;
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            } else if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                assert (n2 == 1);
                n2 = -1;
            } else if (string2.startsWith("~")) {
                string2 = string2.substring(1);
                bl = true;
            }
            Integer n3 = this.map.get(string2);
            if (n3 == null) {
                n3 = this.solver.newVar();
                this.map.put(string2, n3);
                this.decode.push(string2);
                assert (this.decode.size() == n3.intValue());
            }
            vecInt2.push(n2);
            int n4 = (bl ? -1 : 1) * n3;
            vecInt.push(n4);
            assert (vecInt2.size() == vecInt.size());
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                stringBuffer.append("-");
                stringBuffer.append(this.decode.get(-nArray[i] - 1));
            } else {
                stringBuffer.append(this.decode.get(nArray[i] - 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

