/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public final class Lanceur {
    private static final int SAT_EXIT_CODE = 10;
    private static final int UNSAT_EXIT_CODE = 20;
    private static final int UNKNOWN_EXIT_CODE = 0;
    private static InstanceReader reader;

    private Lanceur() {
    }

    public static void main(String[] stringArray) {
        try {
            Lanceur.displayHeader();
            LimitedLearning limitedLearning = new LimitedLearning(10);
            Solver solver = new Solver(new FirstUIP(), limitedLearning, new MixedDataStructureWithBinary());
            limitedLearning.setSolver(solver);
            long l = System.currentTimeMillis();
            Lanceur.readProblem(stringArray, solver, l);
            boolean bl = solver.isSatisfiable();
            Lanceur.displayResult(solver, l, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println("s UNSATISFIABLE");
            System.out.println("c (trivial)");
            System.exit(20);
        }
        catch (TimeoutException timeoutException) {
            System.out.println("c timeout");
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
        System.exit(0);
    }

    private static void displayResult(ISolver iSolver, long l, boolean bl) {
        iSolver.printStat(System.out, "c ");
        System.out.println("c Total CPU time (ms) : " + (double)(System.currentTimeMillis() - l) / 1000.0);
        if (bl) {
            System.out.println("s SATISFIABLE");
            int[] nArray = iSolver.model();
            System.out.println("v " + reader.decode(nArray));
            System.exit(10);
        } else {
            System.out.println("s UNSATISFIABLE");
            System.exit(20);
        }
    }

    private static void readProblem(String[] stringArray, ISolver iSolver, long l) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        System.out.println("c solving " + stringArray[0]);
        System.out.print("c reading problem ");
        reader = new InstanceReader(iSolver);
        reader.parseInstance(stringArray[0]);
        System.out.println("time " + (double)(System.currentTimeMillis() - l) / 1000.0);
        System.out.println("c #vars     " + iSolver.nVars());
        System.out.println("c #clauses  " + iSolver.nConstraints());
    }

    private static void displayHeader() throws IOException {
        System.out.println("c SAT4J: a SATisfiability library for Java (c) 2004-2005 Daniel Le Berre");
        System.out.println("c This is free software under the GNU LGPL licence. See www.sat4j.org for details.");
        URL uRL = Lanceur.class.getResource("/sat4j.version");
        if (uRL != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            System.out.println("c version " + bufferedReader.readLine());
            bufferedReader.close();
        } else {
            System.out.println("c no version file found!!!");
        }
    }
}

