/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class LimitedLearning
implements LearningStrategy,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics none = new NoLearningButHeuristics();
    private final MiniSATLearning all = new MiniSATLearning();
    private final int maxpercent;
    private ILits lits;

    public LimitedLearning() {
        this(10);
    }

    public LimitedLearning(int n) {
        this.maxpercent = n;
    }

    public void setSolver(Solver solver) {
        this.lits = solver.getVocabulary();
        this.none.setVarActivityListener(solver);
        this.all.setDataStructureFactory(solver.getDSFactory());
    }

    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.lits.nVars() * this.maxpercent / 100;
    }

    public String toString() {
        return "Limit learning to clauses of size smaller or equal to " + this.maxpercent + "% of the number of variables";
    }
}

