/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Timer;
import java.util.TimerTask;

public class Solver
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private final IntQueue propQ = new IntQueue();
    protected final IVecInt trail = new VecInt();
    private final IVecInt trailLim = new VecInt();
    private int rootLevel;
    private int[] model = null;
    protected final ILits voc;
    private VarOrder order;
    private final Comparator<Constr> comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy learner;
    protected final AssertingClauseGenerator analyzer;
    private boolean undertimeout;
    private int timeout = Integer.MAX_VALUE;
    protected final DataStructureFactory dsfactory;
    private final SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private boolean[] seen = new boolean[0];
    private final IVecInt preason = new VecInt();
    private final IVecInt outLearnt = new VecInt();
    private final Handle learntConstraint = new Handle();
    private int oldNConstraints;
    private int oldNLearnts;
    private int oldTrail;
    private int oldTrailLim;

    private IVecInt dimacs2internal(IVecInt iVecInt) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            assert (iVecInt.get(i) != 0 && Math.abs(iVecInt.get(i)) <= this.voc.nVars());
            this.__dimacs_out.unsafePush(this.voc.getFromPool(iVecInt.get(i)));
        }
        return this.__dimacs_out;
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(), new VarOrder());
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, VarOrder varOrder) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(), varOrder);
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, SearchParams searchParams) {
        this(assertingClauseGenerator, learningStrategy, dataStructureFactory, searchParams, new VarOrder());
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, SearchParams searchParams, VarOrder varOrder) {
        this.analyzer = assertingClauseGenerator;
        this.learner = learningStrategy;
        this.dsfactory = dataStructureFactory;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.order = varOrder;
        this.voc = dataStructureFactory.getVocabulary();
        varOrder.setLits(this.voc);
        this.params = searchParams;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    public int nConstraints() {
        return this.constrs.size();
    }

    private int nLearnts() {
        return this.learnts.size();
    }

    public void learn(Constr constr) {
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        this.claBumpActivity(constr);
        ++this.stats.learnedclauses;
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.propQ.ensure(n);
        this.order.newVar();
        return n;
    }

    public int newVar(int n) {
        this.voc.ensurePool(n);
        this.order.newVar(n);
        this.seen = new boolean[n + 1];
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.propQ.ensure(n);
        return this.voc.nVars();
    }

    public void addClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        this.addConstr(this.dsfactory.createClause(iVecInt2));
    }

    public void addPseudoBoolean(IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        IVecInt iVecInt3 = this.dimacs2internal(iVecInt);
        assert (iVecInt3.size() == iVecInt.size());
        assert (iVecInt.size() == iVecInt2.size());
        this.addConstr(this.dsfactory.createPseudoBooleanConstraint(iVecInt3, iVecInt2, bl, n));
    }

    public void addAllClauses(IVec iVec) throws ContradictionException {
        for (int i = 0; i < iVec.size(); ++i) {
            this.addClause((IVecInt)iVec.get(i));
        }
    }

    public void addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        for (int i = 0; i < iVecInt.size(); ++i) {
            iVecInt.set(i, -iVecInt.get(i));
        }
        this.addAtLeast(iVecInt, iVecInt.size() - n);
    }

    public void addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        this.addConstr(this.dsfactory.createCardinalityConstraint(iVecInt2, n));
    }

    public boolean simplifyDB() {
        IVec[] iVecArray = new IVec[]{this.constrs, this.learnts};
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < iVecArray[i].size(); ++j) {
                if (((Constr)iVecArray[i].get(j)).simplify()) {
                    ((Constr)iVecArray[i].get(j)).remove();
                    continue;
                }
                iVecArray[i].set(n++, iVecArray[i].get(j));
            }
            iVecArray[i].shrinkTo(n);
        }
        return true;
    }

    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    public boolean enqueue(int n, Constr constr) {
        assert (n > 1);
        if (!this.voc.isUnassigned(n)) {
            return !this.voc.isFalsified(n);
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        this.propQ.insert(n);
        return true;
    }

    public int analyze(Constr constr, Handle handle) {
        int n;
        assert (constr != null);
        this.outLearnt.clear();
        assert (this.outLearnt.size() == 0);
        for (n = 0; n < this.seen.length; ++n) {
            this.seen[n] = false;
        }
        this.analyzer.initAnalyze();
        n = -1;
        this.outLearnt.push(-1);
        int n2 = 0;
        do {
            this.preason.clear();
            assert (constr != null);
            constr.calcReason(n, this.preason);
            if (constr.learnt()) {
                this.claBumpActivity(constr);
            }
            for (int i = 0; i < this.preason.size(); ++i) {
                int n3 = this.preason.get(i);
                if (this.seen[n3 >> 1]) continue;
                this.seen[n3 >> 1] = true;
                if (this.voc.getLevel(n3) == this.decisionLevel()) {
                    this.analyzer.onCurrentDecisionLevelLiteral(n3);
                    continue;
                }
                if (this.voc.getLevel(n3) <= 0) continue;
                this.outLearnt.push(n3 ^ 1);
                n2 = Math.max(n2, this.voc.getLevel(n3));
            }
            do {
                n = this.trail.last();
                constr = this.voc.getReason(n);
                this.undoOne();
            } while (!this.seen[n >> 1]);
        } while (this.analyzer.clauseNonAssertive(constr));
        this.outLearnt.set(0, n ^ 1);
        Constr constr2 = this.dsfactory.createUnregisteredClause(this.outLearnt);
        handle.obj = constr2;
        assert (n2 > -1);
        return n2;
    }

    protected void undoOne() {
        int n = this.trail.last();
        assert (n > 1);
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        IVec<Constr> iVec = this.voc.undos(n);
        assert (iVec != null);
        while (iVec.size() > 0) {
            ((Undoable)((Object)iVec.last())).undo(n);
            iVec.pop();
        }
    }

    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
        for (int i = 0; i < constr.size(); ++i) {
            this.varBumpActivity(constr.get(i));
        }
    }

    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        for (int i = 0; i < this.learnts.size(); ++i) {
            this.learnts.get(i).rescaleBy(1.0E-20);
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.propQ.size() > 0) {
            ++this.stats.propagations;
            int n = this.propQ.dequeue();
            assert (n > 1);
            IVec<Propagatable> iVec = this.dsfactory.getWatchesFor(n);
            for (int i = 0; i < iVec.size(); ++i) {
                ++this.stats.inspects;
                if (iVec.get(i).propagate(this, n)) continue;
                this.dsfactory.conflictDetectedInWatchesFor(n, i);
                this.propQ.clear();
                return (Constr)iVec.get(i);
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.setLearnt();
        constr.assertConstraint(this);
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        assert (this.propQ.size() == 0);
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        assert (this.propQ.size() == 0 || !this.undertimeout);
        for (int i = this.trail.size() - this.trailLim.last(); i > 0; --i) {
            this.undoOne();
        }
        this.trailLim.pop();
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
    }

    Lbool search(long l, long l2) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        int n = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            int n2;
            Constr constr = this.propagate();
            assert (this.propQ.size() == 0);
            if (constr != null) {
                ++this.stats.conflicts;
                ++n;
                if (this.decisionLevel() == this.rootLevel) {
                    return Lbool.FALSE;
                }
                assert (constr != null);
                n2 = this.analyze(constr, this.learntConstraint);
                assert (n2 < this.decisionLevel());
                this.cancelUntil(Math.max(n2, this.rootLevel));
                assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= n2);
                if (this.learntConstraint.obj == null) {
                    return Lbool.FALSE;
                }
                this.record((Constr)this.learntConstraint.obj);
                this.learntConstraint.obj = null;
                this.decayActivities();
                continue;
            }
            if (this.decisionLevel() == 0) {
                ++this.stats.rootSimplifications;
                n2 = this.simplifyDB();
                assert (n2 != 0);
            }
            if (l2 >= 0L && (long)this.learnts.size() > l2) {
                this.reduceDB();
            }
            assert (this.nAssigns() <= this.voc.nVars());
            if (this.nAssigns() == this.voc.nVars()) {
                this.modelFound();
                return Lbool.TRUE;
            }
            if ((long)n >= l) {
                this.cancelUntil(this.rootLevel);
                return Lbool.UNDEFINED;
            }
            ++this.stats.decisions;
            n2 = this.order.select();
            assert (n2 > 1);
            boolean bl = this.assume(n2);
            assert (bl);
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        int n = 0;
        for (int i = 1; i <= this.voc.nVars(); ++i) {
            if (this.voc.isUnassigned(i)) continue;
            this.model[n++] = this.voc.isSatisfied(this.voc.getFromPool(i)) ? i : -i;
        }
        assert (n == this.model.length);
        this.cancelUntil(this.rootLevel);
    }

    protected void reduceDB() {
        Constr constr;
        int n;
        double d = this.claInc / (double)this.learnts.size();
        this.sortOnActivity();
        int n2 = 0;
        for (n = 0; n < this.learnts.size() / 2; ++n) {
            constr = this.learnts.get(n);
            if (!constr.locked()) {
                constr.remove();
                continue;
            }
            this.learnts.set(n2++, this.learnts.get(n));
        }
        while (n < this.learnts.size()) {
            constr = this.learnts.get(n);
            if (!constr.locked() && constr.getActivity() < d) {
                constr.remove();
            } else {
                this.learnts.set(n2++, this.learnts.get(n));
            }
            ++n;
        }
        this.learnts.shrinkTo(n2);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(new VecInt());
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        Lbool lbool = Lbool.UNDEFINED;
        double d = this.params.initConflictBound;
        double d2 = (double)this.nConstraints() * this.params.initLearntBoundConstraintFactor;
        this.stats.reset();
        this.order.init();
        this.model = null;
        if (this.propagate() != null) {
            this.cancelUntil(0);
            return false;
        }
        for (int i = 0; i < iVecInt.size(); ++i) {
            if (this.assume(this.voc.getFromPool(iVecInt.get(i))) && this.propagate() == null) continue;
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        TimerTask timerTask = new TimerTask(){

            public void run() {
                Solver.this.undertimeout = false;
            }
        };
        this.undertimeout = true;
        Timer timer = new Timer(true);
        timer.schedule(timerTask, (long)this.timeout * 1000L);
        while (lbool == Lbool.UNDEFINED && this.undertimeout) {
            lbool = this.search(Math.round(d), Math.round(d2));
            d *= this.params.conflictBoundIncFactor;
            d2 *= this.params.learntBoundIncFactor;
        }
        this.cancelUntil(0);
        timer.cancel();
        if (!this.undertimeout) {
            throw new TimeoutException(" Timeout (" + this.timeout + "s) exceeded");
        }
        return lbool == Lbool.TRUE;
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public VarOrder getOrder() {
        return this.order;
    }

    public void setOrder(VarOrder varOrder) {
        this.order = varOrder;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
    }

    public int nVars() {
        return this.voc.nVars();
    }

    public void backUp() {
        assert (this.propQ.size() == 0);
        assert (this.decisionLevel() == this.rootLevel);
        this.oldNConstraints = this.nConstraints();
        this.oldNLearnts = this.nLearnts();
        this.oldTrail = this.trail.size();
        this.oldTrailLim = this.trailLim.size();
    }

    public void restore() {
        assert (this.oldTrailLim == this.trailLim.size());
        assert (this.oldTrail <= this.trail.size());
        while (this.nConstraints() > this.oldNConstraints) {
            this.constrs.last().remove();
            this.constrs.pop();
        }
        while (this.nLearnts() > this.oldNLearnts) {
            this.learnts.last().remove();
            this.learnts.pop();
        }
        while (this.trail.size() > this.oldTrail) {
            this.undoOne();
        }
        this.oldNConstraints = -1;
        this.oldNLearnts = -1;
        this.oldTrailLim = -1;
        this.oldTrail = -1;
    }

    public void addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
        }
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.outLearnt;
    }

    public Constr getIthConstr(int n) {
        return this.constrs.get(n);
    }

    public void printStat(PrintStream printStream, String string) {
        printStream.println(string + "starts\t: " + this.stats.starts);
        printStream.println(string + "conflicts\t: " + this.stats.conflicts);
        printStream.println(string + "decisions\t: " + this.stats.decisions);
        printStream.println(string + "propagations\t: " + this.stats.propagations);
        printStream.println(string + "inspects\t: " + this.stats.inspects);
        printStream.println(string + "learned literals\t: " + this.stats.learnedliterals);
        printStream.println(string + "learned binary clauses\t: " + this.stats.learnedbinaryclauses);
        printStream.println(string + "learned ternary clauses\t: " + this.stats.learnedternaryclauses);
        printStream.println(string + "learned clauses\t: " + this.stats.learnedclauses);
        printStream.println(string + "root simplifications\t: " + this.stats.rootSimplifications);
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[]{this.analyzer, this.dsfactory, this.learner, this.params};
        stringBuilder.append(string);
        stringBuilder.append("--- Begin Solver configuration ---");
        stringBuilder.append("\n");
        for (Object object : objectArray) {
            stringBuilder.append(string);
            stringBuilder.append(object.toString());
            stringBuilder.append("\n");
        }
        stringBuilder.append(string);
        stringBuilder.append("--- End Solver configuration ---");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

