/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.Comparator;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vec<T>
implements Serializable,
IVec<T> {
    private static final long serialVersionUID = 1L;
    private static final int RANDOM_SEED = 91648253;
    private int nbelem;
    private T[] myarray;
    private static Random rand = new Random(91648253L);

    public Vec() {
        this(5);
    }

    public Vec(int n) {
        this.myarray = new Object[n];
    }

    public Vec(int n, T t) {
        this.myarray = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.myarray[i] = t;
        }
        this.nbelem = n;
    }

    @Override
    public int size() {
        return this.nbelem;
    }

    @Override
    public void shrink(int n) {
        assert (n <= this.size());
        while (n-- > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    @Override
    public void shrinkTo(int n) {
        assert (n <= this.size());
        for (int i = this.nbelem; i > n; --i) {
            this.myarray[i - 1] = null;
        }
        this.nbelem = n;
        assert (this.size() == n);
    }

    @Override
    public void pop() {
        assert (this.size() > 0);
        this.myarray[--this.nbelem] = null;
    }

    @Override
    public void growTo(int n, T t) {
        assert (n >= this.size());
        this.ensure(n);
        for (int i = this.nbelem; i < n; ++i) {
            this.myarray[i] = t;
        }
        this.nbelem = n;
    }

    @Override
    public final void ensure(int n) {
        if (n >= this.myarray.length) {
            Object[] objectArray = new Object[Math.max(n, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, objectArray, 0, this.nbelem);
            this.myarray = objectArray;
        }
    }

    @Override
    public void push(T t) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = t;
    }

    @Override
    public void unsafePush(T t) {
        this.myarray[this.nbelem++] = t;
    }

    @Override
    public void insertFirst(T t) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = t;
            return;
        }
        this.push(t);
    }

    @Override
    public void insertFirstWithShifting(T t) {
        if (this.nbelem > 0) {
            this.ensure(this.nbelem + 1);
            for (int i = this.nbelem; i > 0; --i) {
                this.myarray[i] = this.myarray[i - 1];
            }
            this.myarray[0] = t;
            ++this.nbelem;
            return;
        }
        this.push(t);
    }

    @Override
    public void clear() {
        while (this.nbelem > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    @Override
    public T last() {
        assert (this.size() != 0);
        return this.myarray[this.nbelem - 1];
    }

    @Override
    public T get(int n) {
        return this.myarray[n];
    }

    @Override
    public void set(int n, T t) {
        this.myarray[n] = t;
    }

    @Override
    public void remove(T t) {
        assert (this.size() > 0);
        int n = 0;
        while (this.myarray[n] != t) {
            assert (n < this.size());
            ++n;
        }
        while (n < this.size() - 1) {
            this.myarray[n] = this.myarray[n + 1];
            ++n;
        }
        this.pop();
    }

    @Override
    public T delete(int n) {
        assert (n >= 0);
        assert (n < this.nbelem);
        T t = this.myarray[n];
        this.myarray[n] = this.myarray[--this.nbelem];
        this.myarray[this.nbelem] = null;
        return t;
    }

    @Override
    public void copyTo(IVec<T> iVec) {
        Vec vec = (Vec)iVec;
        int n = this.nbelem + vec.nbelem;
        iVec.ensure(n);
        for (int i = 0; i < this.nbelem; ++i) {
            vec.myarray[i + vec.nbelem] = this.myarray[i];
        }
        vec.nbelem = n;
    }

    @Override
    public void moveTo(IVec<T> iVec) {
        this.copyTo(iVec);
        this.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nbelem - 1; ++i) {
            stringBuffer.append(this.myarray[i]);
            stringBuffer.append(",");
        }
        if (this.nbelem > 0) {
            stringBuffer.append(this.myarray[this.nbelem - 1]);
        }
        return stringBuffer.toString();
    }

    void selectionSort(int n, int n2, Comparator<T> comparator) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (comparator.compare(this.myarray[j], this.myarray[n3]) >= 0) continue;
                n3 = j;
            }
            T t = this.myarray[i];
            this.myarray[i] = this.myarray[n3];
            this.myarray[n3] = t;
        }
    }

    void sort(int n, int n2, Comparator<T> comparator) {
        int n3 = n2 - n;
        if (n2 - n <= 15) {
            this.selectionSort(n, n2, comparator);
        } else {
            T t = this.myarray[rand.nextInt(n3) + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (comparator.compare(this.myarray[++n4], t) < 0) {
                    continue;
                }
                while (comparator.compare(t, this.myarray[--n5]) < 0) {
                }
                if (n4 >= n5) break;
                T t2 = this.myarray[n4];
                this.myarray[n4] = this.myarray[n5];
                this.myarray[n5] = t2;
            }
            this.sort(n, n4, comparator);
            this.sort(n4, n2, comparator);
        }
    }

    @Override
    public void sort(Comparator<T> comparator) {
        this.sort(0, this.nbelem, comparator);
    }

    @Override
    public void sortUnique(Comparator<T> comparator) {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem, comparator);
        int n = 1;
        T t = this.myarray[0];
        for (int i = 1; i < this.nbelem; ++i) {
            if (comparator.compare(t, this.myarray[i]) >= 0) continue;
            t = this.myarray[n] = this.myarray[i];
            ++n;
        }
        this.nbelem = n;
    }

    public static final <A extends Comparable<A>> Comparator<A> defaultComparator() {
        return new Comparator<A>(){

            @Override
            public int compare(A a, A a2) {
                return a.compareTo(a2);
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof IVec) {
            IVec iVec = (IVec)object;
            if (iVec.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (iVec.get(i).equals(this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.nbelem; ++i) {
            n += this.myarray.hashCode() / this.nbelem;
        }
        return n;
    }
}

