

import java.io.Serializable;

/**
 * @author leberre
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class AbstractDataStructureFactory implements DataStructureFactory, Serializable {

	/* (non-Javadoc)
	 * @see org.sat4j.minisat.core.DataStructureFactory#conflictDetectedInWatchesFor(int)
	 */
	public void conflictDetectedInWatchesFor(int p, int i) {
		for (int j = i + 1; j < tmp.size(); j++) {
		 	lits.watch(p, tmp.get(j));
		}
	}
	
	/* (non-Javadoc)
	 * @see org.sat4j.minisat.core.DataStructureFactory#getWatchesFor(int)
	 */
	public IVec<Propagatable> getWatchesFor(int p) {
		tmp.clear();
		lits.watches(p).moveTo(tmp);
		return tmp;
	}
	
    protected ILits lits = new Lits();
    
	private final IVec<Propagatable> tmp = new Vec<Propagatable>();

	
    /* (non-Javadoc)
     * @see org.sat4j.minisat.DataStructureFactory#createVocabulary()
     */
    public ILits getVocabulary() {
        return lits;
    }
    
	protected UnitPropagationListener solver;

	protected Learner learner;
	
	public void setUnitPropagationListener(UnitPropagationListener s) {
	    	solver = s;       	
	}
	public void setLearner(Learner learner) {
	    this.learner = learner;
	}

	public void reset() {
		WLClause.resetIds();
	}

	public void learnContraint(Constr constr) {
	    learner.learn(constr);
	}

	/* (non-Javadoc)
	 * @see org.sat4j.minisat.core.DataStructureFactory#createCardinalityConstraint(org.sat4j.specs.VecInt, int)
	 */
	public Constr createCardinalityConstraint(IVecInt literals, int degree)
		throws ContradictionException {
		throw new UnsupportedOperationException();
	}

    /* (non-Javadoc)
     * @see org.sat4j.minisat.DataStructureFactory#createPseudoBooleanConstraint(org.sat4j.datatype.VecInt, org.sat4j.datatype.VecInt, int)
     */
    public Constr createPseudoBooleanConstraint(IVecInt literals, IVecInt coefs,boolean moreThan,
            int degree) throws ContradictionException {
    	throw new UnsupportedOperationException();
    }

    public Constr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVecInt coefs, int degree) {
    	throw new UnsupportedOperationException();
    }


}
