


/**
 * An assertingClauseGenerator is responsible for the creation of an asserting clause
 * during conflict analysis.
 * 
 * An asserting clause is a clause that will become unit when the
 * solver will backtrack to the latest decision level, providing a 
 * nice way for the solver to backtrack.
 * 
 * 
 * @author leberre
 * 
 */
public interface AssertingClauseGenerator {

    /**
     * hook method called before the analysis.
     *
     */
    void initAnalyze();

    /**
     * hook method called when a literal from the current decision lelvel is found.
     * 
     * @param p the literal in the current decision level
     */
    void onCurrentDecisionLevelLiteral(int p);

    /**
     * method indicating if an asserting clause has been built.
     * 
     * note that this method is called right after a resolution step is finished.
     * 
     * @param reason the reason of the current literal assignment
     * @return false iff the current clause is assertive
     */
    boolean clauseNonAssertive(Constr reason);
}