

import java.io.Serializable;

/*
 * Created on 8 janv. 2004
 * 
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author leberre
 * 
 * Contrainte de cardinalit?
 *  
 */
public class AtLeast implements Constr, Undoable, Serializable {

    private static final long serialVersionUID = 1L;

    /** number of allowed falsified literal */
    private int n;

    /** current number of falsified literals */
    private int counter;

    /**
     * constraint literals
     */
    private final int[] lits;

    private final ILits voc;

    /**
     * @param ps
     *            a vector of literals
     * @param n
     *            the minimal number of satisfied literals
     */
    private AtLeast(ILits voc, IVecInt ps, int n) {
        this.n = ps.size() - n;
        this.voc = voc;
        counter = 0;
        lits = new int[ps.size()];
        ps.moveTo(lits);
        for (int i = 0; i < lits.length; i++) {
            voc.watch(lits[i] ^ 1, this);
        }
    }

    public static AtLeast atLeastNew(UnitPropagationListener s, ILits voc,
            IVecInt ps, int n) throws ContradictionException {
        if (ps.size() < n) throw new ContradictionException();
        int degree = n;
        for (int i = 0; i < ps.size();) {
            // on verifie si le litteral est affecte
            if (!voc.isUnassigned(ps.get(i))) {
                // Si le litteral est satisfait,
                // ?a revient ? baisser le degr?
                if (voc.isSatisfied(ps.get(i))) {
                    degree--;
                }
                // dans tous les cas, s'il est assign?,
                // on enleve le ieme litteral
                ps.delete(i);
            } else {
                // on passe au litt?ral suivant
                i++;
            }
        }

        // on trie le vecteur ps
        ps.sortUnique();

        // ?limine les clauses tautologiques
        // deux litt?raux de signe oppos?s apparaissent dans la m?me
        // clause
        for (int i = 0; i < ps.size() - 1;) {
            if (ps.get(i) == (ps.get(i + 1) ^ 1)) {
                // la clause est tautologique
                // TODO
                // ps.set(i, ps.last());
                // ps.pop();
                // ps.set(i, ps.last());
                // ps.pop();
                // degree--;
                i++;
            } else {
                i++;
            }
        }

        if (ps.size() == degree) {
            for (int i = 0; i < ps.size(); i++) {
                if (!s.enqueue(ps.get(i))) { throw new ContradictionException(); }
            }
            return null;
        }

        if (ps.size() < degree) throw new ContradictionException();
        if (degree == 0) return null;

        return new AtLeast(voc, ps, degree);
    }

    /*
     * (non-Javadoc)
     * 
     * @see Constr#remove(Solver)
     */
    public void remove() {
        for (int i = 0; i < lits.length; i++) {
            voc.watches(lits[i]).remove(this);
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see Constr#propagate(Solver, Lit)
     */
    public boolean propagate(UnitPropagationListener s, int p) {
        // remet la clause dans la liste des clauses regardees
        voc.watch(p, this);

        if (counter == n) return false;

        counter++;
        voc.undos(p).push(this);

        // If no more can be false, enqueue the rest:
        if (counter == n) for (int i = 0; i < lits.length; i++) {
            if (voc.isUnassigned(lits[i])) {
                if (!s.enqueue(lits[i], this)) { return false; }
            }
        }
        return true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see Constr#simplify(Solver)
     */
    public boolean simplify() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see Constr#undo(Solver, Lit)
     */
    public void undo(int p) {
        counter--;
    }

    /*
     * (non-Javadoc)
     * 
     * @see Constr#calcReason(Solver, Lit, Vec)
     */
    public void calcReason(int p, IVecInt outReason) {
        int c = (p == ILits.UNDEFINED) ? -1 : 0;
        for (int i = 0; i < lits.length; i++) {
            if (voc.isFalsified(lits[i])) {
                outReason.push(lits[i] ^ 1);
                if (++c == n) return;
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.sat4j.minisat.datatype.Constr#learnt()
     */
    public boolean learnt() {
        // Ces contraintes ne sont pas apprises pour le moment.
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.sat4j.minisat.datatype.Constr#getActivity()
     */
    public double getActivity() {
        // TODO Auto-generated method stub
        return 0;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.sat4j.minisat.datatype.Constr#incActivity(double)
     */
    public void incActivity(double claInc) {
        // TODO Auto-generated method stub

    }

    /*
     * For learnt clauses only @author leberre
     */
    public boolean locked() {
        // FIXME need to be adapted to AtLeast
        // return lits[0].getReason() == this;
        return true;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return lits.length;
    }

    public int get(int i) {
        return lits[i];
    }

    public void rescaleBy(double d) {
        throw new UnsupportedOperationException();
    }
    
    public int analyse(Handle ref){
    	throw new UnsupportedOperationException();
    }
    
    public void assertConstraint(UnitPropagationListener s) {
    	throw new UnsupportedOperationException();
    }
}
