

import java.io.Serializable;

/**
 * @author leberre
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class BinaryClauses implements Constr,Serializable {
    
    private static final long serialVersionUID = 1L;
    
    private final ILits voc;
    private final IVecInt clauses = new VecInt();
    private final int reason;
    private int conflictindex=-1;
    
    /**
     * 
     */
    public BinaryClauses(ILits voc, int p) {
        this.voc = voc;
        this.reason = p;
    }
    
    public void addBinaryClause(int p) {
        clauses.push(p);
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#remove()
     */
    public void remove() {
        // do nothing
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#propagate(org.sat4j.minisat.UnitPropagationListener, int)
     */
    public boolean propagate(UnitPropagationListener s, int p) {
        assert voc.isFalsified(this.reason);
        voc.watch(p,this);
        for (int i=0;i<clauses.size();i++) {
            if (!s.enqueue(clauses.get(i),this)) {
                conflictindex=i;
                return false;
            }
        }
        return true;
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#simplify()
     */
    public boolean simplify() {
        for (int i=0;i<clauses.size();i++) {
            if (voc.isSatisfied(clauses.get(i))) {
                return true;
            }
            if (voc.isFalsified(clauses.get(i))) {
                clauses.delete(i);
            }

        }
        return false;
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#undo(int)
     */
    public void undo(int p) {
        // no to do
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#calcReason(int, org.sat4j.datatype.VecInt)
     */
    public void calcReason(int p, IVecInt outReason) {
        outReason.push(this.reason^1);
        if (p==ILits.UNDEFINED) {
//            int i=0;
//            while(!voc.isFalsified(clauses.get(i))) {
//                i++;
//            }
            assert conflictindex>-1;
            outReason.push(clauses.get(conflictindex)^1);
        }
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#learnt()
     */
    public boolean learnt() {
        return false;
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#incActivity(double)
     */
    public void incActivity(double claInc) {
        // TODO Auto-generated method stub
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#getActivity()
     */
    public double getActivity() {
        // TODO Auto-generated method stub
        return 0;
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#locked()
     */
    public boolean locked() {
        return false;
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#setLearnt()
     */
    public void setLearnt() {
        // TODO Auto-generated method stub
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#register()
     */
    public void register() {
        // TODO Auto-generated method stub
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#rescaleBy(double)
     */
    public void rescaleBy(double d) {
        // TODO Auto-generated method stub
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#size()
     */
    public int size() {
        // TODO Auto-generated method stub
        return clauses.size();
    }
    /* (non-Javadoc)
     * @see org.sat4j.minisat.Constr#get(int)
     */
    public int get(int i) {
        // TODO Auto-generated method stub
        throw new UnsupportedOperationException();
    }
    
    public int analyse(Handle ref){
    	throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener s) {
    	throw new UnsupportedOperationException();
    }
}
