



/*
 * Created on 16 oct. 2003
 *
 */

/**
 * @author leberre
 * Cette interface repr?sente les services offerts par une contrainte
 */
public interface Constr extends Propagatable {

    /**
     * Enl?ve une contrainte du prouveur
     *
     * @param s
     *                  un prouveur
     */
    void remove();

    /**
     * Simplifie une contrainte, par exemple en enlevant les litt?raux
     * falsifi?s.
     * @param s
     *                  un prouveur
     * @return true ssi la contrainte est satisfaite.
     */
    boolean simplify();

    /**
     * Calcule la cause de l'affection d'un litt?ral
     *
     * @param s
     *                  un prouveur
     * @param p
     *                  un litt?ral falsifi? (ou Lit.UNDEFINED)
     * @param outReason
     *                  la liste des litt?raux falsifi?s dont la n?gation
     *                  correspond ? la raison de l'affectation.
     */
    void calcReason(int p, IVecInt outReason);

    /**
     * @return
     */
    boolean learnt();

    /**
     * @param claInc
     */
    void incActivity(double claInc);

    /**
     * @return
     */
    double getActivity();
    
    /**
     * Indicate wether a constraint is responsible from an assignment.
     * 
     * @return true if a constraint is a "reason" for an assignment.
     */
    boolean locked();
    
    /**
     * Mark a constraint as learnt.
     *
     */
    
    void setLearnt();
    
    /**
     * Register the constraint to the solver.
     *
     */
    void register();
    
    /**
     * Rescale the clause activity by a value.
     * @param d
     */
    void rescaleBy(double d);
    
    /**
     * Returns the number of literals in the constraint.
     * 
     * @return
     */
    int size();
    
    /**
     * returns the ith literal in the constraint
     * 
     * @param i
     * @return
     */
    int get(int i);
    
    int analyse(Handle ref);
    
    void assertConstraint(UnitPropagationListener s);
}
