



/**
 * @author leberre
 *
 * The aim of the factory is to provide a concrete implementation of clauses,
 * cardinality constraints and pseudo boolean consraints.
 * 
 */
public interface DataStructureFactory {

    	/**
         * @param literals a set of literals using Dimacs format (signed non null integers).
         * @return null if the constraint is a tautology.
         * @throws ContradictionException the constraint is trivially unsatisfiable.
         * @throws UnsupportedOperationException there is no concrete implementation for that constraint.

         */
        Constr createClause(IVecInt literals) throws ContradictionException;
    	Constr createUnregisteredClause(IVecInt literals);
    	void learnContraint(Constr constr);
    	
    	Constr createCardinalityConstraint(IVecInt literals, int degree) throws ContradictionException;
    	
    	Constr createPseudoBooleanConstraint(IVecInt literals, IVecInt coefs, boolean moreThan, int degree) throws ContradictionException;
    	
    	Constr createUnregisteredPseudoBooleanConstraint(IVecInt literals, IVecInt coefs, int degree);

    	void setUnitPropagationListener(UnitPropagationListener s);
    	
    	void setLearner(Learner l);
    	
		void reset();
		
		ILits getVocabulary();
		/**
		 * @param p
		 * @return
		 */
		IVec<Propagatable> getWatchesFor(int p);
		/**
		 * @param p
		 * @param i the index of the conflicting constraint
		 */
		void conflictDetectedInWatchesFor(int p, int i);
 }
