

import java.io.Serializable;




/**
 * FirstUIP scheme introduced in Chaff.
 * 
 * Here the generator stops when a syntactical criteria is met:
 * only one literal in the current decision level appears in the
 * generated clause.
 * 
 * The computation is done by counting the literals appearing in 
 * the current decision level and decrementing that counter when 
 * a resolution step is done.
 * 
 * @author leberre
 *
 */
public class FirstUIP implements AssertingClauseGenerator, Serializable {

    private static final long serialVersionUID = 1L;
    
    private int counter;
    
    public void initAnalyze() {
        counter = 0;
    }
    
    public void onCurrentDecisionLevelLiteral(int p) {
        counter++;
    }
    
    public boolean clauseNonAssertive(Constr reason) {
        return --counter>0;
    }

}
