


/**
 * @author leberre
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public interface ILits {

    public static int UNDEFINED = -1;

    public abstract void init(int nvar);

    public abstract int getFromPool(int x);

    public abstract void resetPool();

    public abstract void ensurePool(int howmany);

    public abstract void unassign(int lit);

    public abstract void satisfies(int lit);

    public abstract boolean isSatisfied(int lit);

    public abstract boolean isFalsified(int lit);

    public abstract boolean isUnassigned(int lit);

    public abstract int nVars();

    public abstract int not(int lit);

    public abstract void reset(int lit);

    public abstract int getLevel(int lit);

    public abstract void setLevel(int lit, int l);

    public abstract Constr getReason(int lit);

    public abstract void setReason(int lit, Constr r);

    public abstract IVec<Constr> undos(int lit);

    public abstract void watch(int lit, Propagatable c);
    /**
     * 
     * @param lit a literal
     * @return the list of all the constraints that watch the negation of lit
     */
    public abstract IVec<Propagatable> watches(int lit);
    
   public abstract String valueToString(int lit);
}