

import java.io.FileNotFoundException;
import java.io.IOException;


/**
 * @author leberre
 * 
 * An instance reader has the responsability to choose the right reader
 * according to the input.
 */
public class InstanceReader {

	private final DimacsReader dimacs;

	private final GoodOPBReader opb;

	private Reader reader = null;

	public InstanceReader(ISolver solver) {
		dimacs = new DimacsReader(solver);
		opb = new GoodOPBReader(solver);
	}

	public IProblem parseInstance(String filename)
			throws FileNotFoundException, ParseFormatException, IOException,
			ContradictionException {
		if (filename.endsWith(".opb") || filename.endsWith(".opb.gz")) {
			reader = opb;
			return opb.parseInstance(filename);
		} 
		reader = dimacs;
		return dimacs.parseInstance(filename);
	}

	public String decode(int[] model) {
		return reader.decode(model);
	}
}
