

import java.io.Serializable;


/*
 * Created on 9 oct. 2003
 *  
 */

/**
 * @author leberre
 * 
 * Implantation d'une queue � l'aide d'un tableau
 */
public final class IntQueue implements Serializable {
    
    
    private static final long serialVersionUID = 1L;


    private static final int INITIAL_QUEUE_CAPACITY = 10;
    
    /**
     * pour ajouter un �l�ment dans la queue.
     * 
     * @param x
     *            l'�l�ment � ajouter
     */
    public void insert(final int x) {
        ensure(size + 1);
        myarray[size++] = x;
    }
    
    /**
     * retourne le prochain �l�ment de la queue. Attention, comportement
     * impr�visible si la queue est vide!!!!
     * 
     * @return le premier �l�ment de la queue
     */
    public int dequeue() {
        assert first < size;
        int o = myarray[first];
        first++;
        return o;
    }
    
    /**
     * Vide la queue
     *  
     */
    public void clear() {
        size = 0;
        first = 0;
    }
    
    /**
     * Pour conna�tre la taille de la queue.
     * 
     * @return le nombre d'�l�ments restant dans la queue
     */
    public int size() {
        return size - first;
    }
    
    /**
     * Utilis�e pour accro�tre dynamiquement la taille de la queue.
     * 
     * @param nsize
     *            la taille maximale de la queue
     */
    public void ensure(final int nsize) {
        if (nsize >= myarray.length) {
            int[] narray = new int[Math.max(nsize, size * 2)];
            System.arraycopy(myarray, 0, narray, 0, size);
            myarray = narray;
        }
    }
    
    public String toString() {
        StringBuffer stb = new StringBuffer();
        stb.append(">");
        for (int i=first;i<size-1;i++) {
            stb.append(myarray[i]);
            stb.append(" ");
        }
        if (first!=size) {
            stb.append(myarray[size-1]);
        }
        stb.append("<");
        return stb.toString();
    }
    private int[] myarray = new int[INITIAL_QUEUE_CAPACITY];
    
    
    private int size = 0;
    
    private int first = 0;
    
}
