


/*
 * Created on 9 oct. 2003
 * 
 * Probl�me : comment rendre opposite final ?
 */

/**
 * @author leberre
 * 
 * Cette classe repr�sente les valeurs bool�ennes qui peuvent �tre associ�es
 * aux litt�raux.
 */
public enum Lbool {

    FALSE("F"),
    TRUE("T"),
    UNDEFINED("U");


    static {
        // on cr�e ici les r�gles de la n�gation
        FALSE.opposite = TRUE;
        TRUE.opposite = FALSE;
        UNDEFINED.opposite = UNDEFINED;
    }

    private Lbool(String symbol) {
        this.symbol = symbol;
    }

    /**
     * N�gation bool�enne
     * 
     * @return la n�gation de la valeur bool�nne. La n�gation de la valeur
     *             UNDEFINED est UNDEFINED.
     */
    public Lbool not() {
        return opposite;
    }

    /**
     * Une valeur bool�enne est repr�sent�e par T,F ou U.
     * 
     * @return l'une des trois lettres
     */
    public String toString() {
        return symbol;
    }

    /**
     * Le symbole repr�sentant la valeur bool�enne
     */
    private final String symbol;

    /**
     * la valeur bool�enne oppos�e
     */
    private Lbool opposite;

}
