

import java.io.Serializable;


/**
 * Learn only clauses which size is smaller than a percentage of the number of variables.
 * 
 * @author leberre
 *
 */
public class LimitedLearning implements LearningStrategy, Serializable {

    private static final long serialVersionUID = 1L;
    
    private final NoLearningButHeuristics none;
    private final MiniSATLearning all;

    private final int maxpercent;
    
    private ILits lits;
    
    public LimitedLearning() {
        this(10);
    }
    
    public LimitedLearning(int percent) {
        maxpercent=percent;   
    }
    
    {
    	none = new NoLearningButHeuristics();
        all = new MiniSATLearning();

    }
    
    public void setSolver(Solver s) {
        this.lits=s.getVocabulary(); 
        none.setVarActivityListener(s);
        all.setDataStructureFactory(s.getDSFactory());
    }
        
    /* (non-Javadoc)
     * @see org.sat4j.minisat.LearningScheme#learns(org.sat4j.minisat.Solver, org.sat4j.minisat.datatype.Vec)
     */
    public void learns(Constr constr) {
        if (learningCondition(constr)) {
            all.learns(constr);
        } else {
            none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr clause) {
        return clause.size()<=lits.nVars()*maxpercent/100;
    }
    
    public String toString() {
    	return "Limit learning to clauses of size smaller or equal to "+maxpercent+ "% of the number of variables";
    }
}
