

import java.io.Serializable;

/**
 * 
 * @author laihem 
 * @author leberre 
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Lits implements Serializable, ILits {



    private static final long serialVersionUID = 1L;

    private boolean pool[] = new boolean[0];

    protected IVec<Propagatable> [] watches = new IVec[0];

    private int [] level = new int[0];

    public Lbool [] truthValue = new Lbool[1];

    private Constr [] reason = new Constr[0];

    private IVec<Constr> [] undos = new IVec[0];

    public Lits() {
    }

    public void init(int nvar) {
        assert nvar>=0;
        // let some space for unused 0 indexer. 
        int nvars = nvar + 1;
        boolean [] npool = new boolean[nvars];
        System.arraycopy(pool,0,npool,0,pool.length);
        pool = npool;
        
        level = new int[nvars];
        int [] nlevel = new int[nvars];
        System.arraycopy(level,0,nlevel,0,level.length);
        level = nlevel;
        
        IVec[] nwatches = new IVec[2 * nvars];
        System.arraycopy(watches,0,nwatches,0,watches.length);
        watches = nwatches;
        
        Lbool [] ntruthValue = new Lbool[nvars];
        System.arraycopy(truthValue,0,ntruthValue,0,truthValue.length);
        truthValue = ntruthValue;
        
        IVec [] nundos = new IVec[nvars];
        System.arraycopy(undos,0,nundos,0,undos.length);
        undos = nundos;
        
        Constr [] nreason = new Constr[nvars];
        System.arraycopy(reason,0,nreason,0,reason.length);
        reason = nreason;
    }

    public int getFromPool(int x) {
        int var = Math.abs(x);
        assert var<pool.length;
        
        int lit = ((x < 0) ? (var << 1) ^ 1 : (var << 1));
        assert lit>1;
        if (!pool[var]) {
            pool[var] = true;
            watches[var<<1] = new Vec<Propagatable>();
            watches[(var<<1) | 1] = new Vec<Propagatable>();
            truthValue[var] = Lbool.UNDEFINED;
            undos[var] = new Vec<Constr>();
            level[var] = -1;
            // reset(var);

        }
        return lit;
    }

    public void resetPool() {
        for (int i = 0; i < pool.length; i++) {
            if (pool[i]) {
                reset(i);
            }
        }
    }

    public void ensurePool(int howmany) {
        init(howmany);
    }
    
    public void unassign(int lit) {
        assert truthValue[lit>>1]!=Lbool.UNDEFINED;
        truthValue[lit>>1]=Lbool.UNDEFINED;
    }
    
    public void satisfies(int lit) {
        assert truthValue[lit>>1]==Lbool.UNDEFINED;
        truthValue[lit>>1]=satisfyingValue(lit);
    }
    
    private static final Lbool satisfyingValue(int lit) {
        return ((lit&1)==0)?Lbool.TRUE:Lbool.FALSE;
    }
    
    public boolean isSatisfied(int lit) {
        return truthValue[lit>>1]==satisfyingValue(lit);
    }
    
    public boolean isFalsified(int lit) {
        Lbool falsified = ((lit&1)==0)?Lbool.FALSE:Lbool.TRUE;
        return truthValue[lit>>1]==falsified;
    }

    public boolean isUnassigned(int lit) {
        return truthValue[lit>>1]==Lbool.UNDEFINED;
    }

    public String valueToString(int lit){
    	if (isUnassigned(lit))
    			return "?";
    	if (isSatisfied(lit))
    		return "T";
    	return "F";
    }
    
    public int nVars() {
        return truthValue.length -1;
    }

    public int not(int lit) {
        return lit ^ 1;
    }

    public static String toString(int lit) {
        return ((lit&1)==0?"":"-") + (lit >> 1);
    }

    public void reset(int lit) {
        watches[lit].clear();
        watches[lit ^ 1].clear();
        level[lit >> 1] = -1;
        truthValue[lit >> 1] = Lbool.UNDEFINED;
        reason[lit >> 1] = null;
        undos[lit >> 1].clear();
    }

    public int getLevel(int lit) {
        return level[lit >> 1];
    }

    public void setLevel(int lit, int l) {
        level[lit >> 1] = l;
    }

    public Constr getReason(int lit) {
        return reason[lit >> 1];
    }

    public void setReason(int lit, Constr r) {
        reason[lit >> 1] = r;
    }

    public IVec<Constr> undos(int lit) {
        return undos[lit >> 1];
    }

    public void watch(int lit, Propagatable c) {
        watches[lit].push(c);
    }

    public IVec<Propagatable> watches(int lit) {
        return watches[lit];
    }

}
