
import java.io.Serializable;
/**
 * MiniSAT learning scheme.
 * 
 * @author leberre
 * 
 */
public class MiniSATLearning implements LearningStrategy, Serializable {
    private static final long serialVersionUID = 1L;
    
    private DataStructureFactory dsf;
    
    public void setDataStructureFactory(DataStructureFactory dsf) {
        this.dsf = dsf;
    }
    /*
     * (non-Javadoc)
     * 
     * @see org.sat4j.minisat.LearningScheme#learns(org.sat4j.minisat.Solver,
     *      org.sat4j.minisat.datatype.Vec)
     */
    public void learns(Constr constr) {
        // va contenir une nouvelle clause ou null si la clause est unitaire
        dsf.learnContraint(constr);
     }
}