


/**
 * @author leberre
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class MixedDataStructureWithBinary extends MixedDataStructureDaniel {

    private static final long serialVersionUID = 1L;
    
    private final ILits2 mlits = new Lits2(); 

    {
    	lits = mlits;
    }
    
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.DataStructureFactory#createVocabulary()
     */
    public ILits getVocabulary() {
    	return lits;
    }
	/* (non-Javadoc)
	 * @see org.sat4j.minisat.DataStructureFactory#createClause(org.sat4j.datatype.VecInt)
	 */
	public Constr createClause(IVecInt literals) throws ContradictionException {
		IVecInt v=WLClause.sanityCheck(literals,lits,solver);
		if (v==null)
			return null;
		if (v.size()==2) {
		    mlits.binaryClauses(v.get(0),v.get(1));
		    return null;
		}
		return WLClause.brandNewClause(solver,lits,v);
	}
	
	
	/* (non-Javadoc)
	 * @see org.sat4j.minisat.DataStructureFactory#learnContraint(org.sat4j.minisat.Constr)
	 */
	public void learnContraint(Constr constr) {
		if (constr.size()==2) {
          mlits.binaryClauses(constr.get(0),constr.get(1));
          // solver.getStats().learnedbinaryclauses++;
		} else {
			super.learnContraint(constr);
		}
	}
}
