

import java.io.Serializable;

/**
 * Allows MiniSAT to do backjumping without learning.
 * The literals appearing in the reason have their activity increased.
 * That solution does not look good for VLIW-SAT-1.0 benchmarks (1785s vs 1346s).
 * 
 * @author leberre
 *
 */
public class NoLearningButHeuristics implements LearningStrategy, Serializable {

    private static final long serialVersionUID = 1L;
    
    private VarActivityListener val;
    
    public void setVarActivityListener(VarActivityListener s) {
        this.val = s;        
    }
    
    /* (non-Javadoc)
     * @see org.sat4j.minisat.LearningScheme#learns(org.sat4j.minisat.Solver, org.sat4j.minisat.datatype.Vec)
     */
    public void learns(Constr reason) {
        for (int i=0;i<reason.size();i++) {
            int q = reason.get(i);
            assert q>1;
            val.varBumpActivity(q);
        }
    }

}
