

/**
 * Exception launched when there is a problem during parsing.
 * 
 * @author leberre
 * @see IParser
 *  
 */
public class ParseFormatException extends Exception {

    private static final long serialVersionUID = 1L;

    /**
     * Constructor for ParseFormatException.
     */
    public ParseFormatException() {
        super("DIMACS Format Error");
    }

    /**
     * Constructor for ParseFormatException.
     * 
     * @param message
     *            the error message
     */
    public ParseFormatException(String message) {
        super("DIMACS Format error: " + message);
    }

    /**
     * Constructor for ParseFormatException.
     * 
     * @param message
     *            the error message
     * @param cause
     *            the cause of the exception
     */
    public ParseFormatException(String message, Throwable cause) {
        super("DIMACS Format error: " + message, cause);
    }

    /**
     * Constructor for ParseFormatException.
     * 
     * @param cause
     *            the cause of the exception
     */
    public ParseFormatException(Throwable cause) {
        super(cause);
    }

}
