

import java.io.Serializable;
import java.lang.reflect.Field;

/*
 * Created on 29 oct. 2003
 * 
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @author leberre
 * 
 * Structure de donn�es permettant de configurer le prouveur.
 */
public class SearchParams implements Serializable {

    private static final long serialVersionUID = 1L;

    public SearchParams() {
    	
       this(0.95,0.999,1.5,1.04,0.55,103);
      
    	//this(0.95, 0.999,1.5,1.0,0.5,100);
    }
    
    public SearchParams(int conflictBound) {
        this(0.95, 0.999,1.5,1.1,0.5,conflictBound);
    }
    
    public SearchParams(double initLearntbound, int conflictBound) {
        this(0.95, 0.999,1.5,1.1,initLearntbound,conflictBound);
    }

    public SearchParams(double learntincfactor, double confincfactor, double initLearntbound, int conflictBound) {
        this(0.95, 0.999,learntincfactor,confincfactor,initLearntbound,conflictBound);
    }
    /**
     * @param d
     *                  variable decay
     * @param e
     *                  clause decay
     * @param f
     * 					conflict bound increase factor
     * @param g
     * 					learnt bound increase factor
     * @param h
     * 					initial bound for learnt clauses as a factor 
     * 					of the number of constraints
     * @param i
     * 					initialConflictBound
     */
    public SearchParams(double d, double e, double f, double g, double h, int i) {
        varDecay = d;
        claDecay = e;
        conflictBoundIncFactor = f;
        learntBoundIncFactor = g;
        initLearntBoundConstraintFactor = h;
        initConflictBound = i;
    }

    /**
     * @return la valeur de clause decay
     */
    public double getClaDecay() {
        return claDecay;
    }

    /**
     * @return la valeur de var decay
     */
    public double getVarDecay() {
        return varDecay;
    }

    private double claDecay;

    private double varDecay;

    public double conflictBoundIncFactor;

    public double learntBoundIncFactor;

    public double initLearntBoundConstraintFactor;

    public int initConflictBound;

    
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuilder stb = new StringBuilder();
		for (Field field : SearchParams.class.getFields()) {
			stb.append(field.getName());
			stb.append("=");
			try {
				stb.append(field.get(this));
			} catch (IllegalArgumentException e) {
				// TODO Bloc catch auto-généré
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				// TODO Bloc catch auto-généré
				e.printStackTrace();
			}
			stb.append(" ");
		}
		return stb.toString();
	}
}
