
import java.io.Serializable;

/*
 * Created on 16 oct. 2003
 *  
 */

/**
 * @author leberre
 * 
 * Heuristique du prouveur. Changement par rapport au MiniSAT original : la
 * gestion activity est faite ici et non plus dans Solver.
 */
public class VarOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Comparateur permettant de trier les variables
     */
    private static final double VAR_RESCALE_FACTOR = 1e-100;

    private static final double VAR_RESCALE_BOUND = 1 / VAR_RESCALE_FACTOR;

    /**
     * mesure heuristique de l'activit� d'une variable.
     */
    protected double[] activity = new double[1];

    /**
     * Derni�re variable choisie
     */
    protected int lastVar=1;

    /**
     * Ordre des variables
     */
    protected final IVecInt order = new VecInt();

    private double varDecay = 1.0;

    /**
     * incr�ment pour l'activit� des variables.
     */
    private double varInc = 1.0;

    /**
     * position des variables
     */
    protected int[] varpos = new int[1];

    
    protected ILits lits;
    
    public VarOrder() {
        order.push(ILits.UNDEFINED);
    }

    public void setLits(ILits lits) {
    	this.lits = lits;
    }
    
    /**
     * Appel�e quand une nouvelle variable est cr��e.
     *  
     */
    public void newVar() {
        newVar(1);
    }

    /**
     * Appel�e lorsque plusieurs variables sont cr��es
     * 
     * @param howmany
     *                  le nombre de variables cr��es
     */
    public void newVar(int howmany) {
        int nlength = varpos.length + howmany;
        int[] nvarpos = new int[nlength];
        double[] nactivity = new double[nlength];
        order.ensure(nlength);
        int length = varpos.length;
        System.arraycopy(varpos, 0, nvarpos, 0, length);
        System.arraycopy(activity, 0, nactivity, 0, length);
        for (int i = length; i < nlength; i++) {
            assert i>0;
            assert i<=lits.nVars():""+lits.nVars()+"/"+i;
            order.push(lits.getFromPool(i)^1); //Looks a
                                                                // promising
                                                                // approach
            nvarpos[i] = i;
            nactivity[i] = 0.0;
        }
        varpos = nvarpos;
       activity = nactivity;
    }

    /**
     * S�lectionne une nouvelle variable, non affect�e, ayant l'activit� la
     * plus �lev�e.
     * 
     * @return Lit.UNDEFINED si aucune variable n'est trouv�e
     */
    public int select() {
        assert lastVar>0;
        for (int i = lastVar; i < order.size(); i++) {
            assert i>0;
            if (lits.isUnassigned(order.get(i))) {
                lastVar = i;
                return order.get(i);
            }
        }
        return ILits.UNDEFINED;
    }

    /**
     * Change la valeur de varDecay.
     * 
     * @param d
     *                  la nouvelle valeur de varDecay
     */
    public void setVarDecay(double d) {
        varDecay = d;
    }

    /**
     * M�thode appel�e quand la variable x est d�saffect�e.
     * 
     * @param x
     */
    public void undo(int x) {
        assert x>0;
        assert x<order.size();
        int pos = varpos[x];
        if (pos < lastVar) {
            lastVar = pos;
        }
        assert lastVar>0;
    }

//    /**
//     * Appel�e lorsque l'activit� de toutes les variables ont �t� chang�es.
//     *  
//     */
//    public void updateAll() {
//        order.sort(comparator);
//        for (int i = 0; i < order.size(); i++) {
//            int indexer = order.get(i)>>1;
//            varpos[indexer] = i;
//        }
//        lastVar = 1;
//    }

    /**
     * Appel�e lorsque l'activit� de la variable x a chang�.
     * 
     * @param x
     */
    public void updateVar(int p) {
        assert p>1;
        if ((activity[p>>1] += varInc) > VAR_RESCALE_BOUND) {
            varRescaleActivity();
        }

        for (int i = varpos[p>>1];
            i > 1 // because there is nothing at i=0
            && (activity[order.get(i - 1)>>1] < activity[p>>1]);
            i--) {
            assert order.get(i)== p || order.get(i) == (p^1);
            assert i>1;
            // echange p avec son predecesseur
            int orderpm1 = order.get(i - 1);
            assert varpos[orderpm1>>1]==i-1;
            varpos[orderpm1>>1] = i;
            varpos[p>>1] = i - 1;

            order.set(i,orderpm1);
            order.set(i - 1,p);
        }
    }

    /**
     *  
     */
    public void varDecayActivity() {
        varInc *= varDecay;
    }

    /**
     *  
     */
    private void varRescaleActivity() {
        for (int i = 1; i < activity.length; i++) {
            activity[i] *= VAR_RESCALE_FACTOR;
        }
        varInc *= VAR_RESCALE_FACTOR;
    }

    public double varActivity(int p) {
        return activity[p>>1];
    }
    
    /**
     *  
     */
    public int numberOfInterestingVariables() {
        int cpt = 0;
        for (int i = 1; i < activity.length; i++) {
            if (activity[i] > 1.0) {
                cpt++;
            }
        }
        return cpt;
    }

    public void init() {
//        for (int i = 0; i < order.length; i++) {
//            if (order[i].occurrences() < order[i].not().occurrences()) {
//                order[i] = order[i].not();
//            }
//        }
    }
    /**
     * Affiche les litt�raux dans l'ordre de l'heuristique, la valeur de
     * l'activite entre ().
     * 
     * @return les litt�raux dans l'ordre courant.
     */
    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 1; i < order.size(); i++) {
            int p = order.get(i);
            stb.append(p);
            stb.append("(");
            stb.append(activity[p>>1]);
            stb.append(")");
            stb.append(",");
        }
        return stb.toString();
    }
    
    public ILits getVocabulary() {
        return lits;
    }
}
