

import java.io.Serializable;
import java.util.Random;

/*
 * Created on 9 oct. 2003
 *  
 */

/**
 * @author leberre
 *  
 */
public class VecInt implements Serializable, IVecInt {

    private static final long serialVersionUID = 1L;

    private static final int RANDOM_SEED = 91648253;

    public VecInt() {
        this(5);
    }
    
    public VecInt(int size) {
        myarray = new int[size];
    }

    /**
     * Construit un vecteur contenant de taille size rempli � l'aide de size
     * pad.
     * 
     * @param size
     *            la taille du vecteur
     * @param pad
     *            l'objet servant � remplir le vecteur
     */
    public VecInt(int size, int pad) {
        myarray = new int[size];
        for (int i = 0; i < size; i++) {
            myarray[i] = pad;
        }
        nbelem = size;
    }

    public int size() {
        return nbelem;
    }

    /**
     * Remove the latest nofelems elements from the vector 
     * @param nofelems
     */
    public void shrink(int nofelems) {
    	assert nofelems>=0;
        assert nofelems <= size(); 
        nbelem -= nofelems;
    }

    public void shrinkTo(int newsize) {
    	assert newsize >=0;
        assert newsize < nbelem; 
        nbelem = newsize;
    }

    /**
     * d�pile le dernier �l�ment du vecteur. Si le vecteur est vide, ne fait
     * rien.
     */
    public IVecInt pop() {
        assert size() != 0; 
        --nbelem;
        return this;
    }

    public void growTo(int newsize, final int pad) {
        assert newsize > size();
        ensure(newsize);
        while(--newsize>=0) {
            myarray[nbelem++] = pad;
        }
    }

    public void ensure(int nsize) {
        if (nsize >= myarray.length) {
            int[] narray = new int[Math.max(nsize, nbelem * 2)];
            System.arraycopy(myarray, 0, narray, 0, nbelem);
            myarray = narray;
        }
    }

    public IVecInt push(int elem) {
        ensure(nbelem + 1);
        myarray[nbelem++] = elem;
        return this;
    }

    public void unsafePush(int elem) {
        myarray[nbelem++] = elem;
    }
    
    public void clear() {
        nbelem = 0;
    }

    public int last() {
        assert nbelem>0;
        return myarray[nbelem - 1];
    }

    public int get(int i) {
    	assert i>=0;
    	assert i<nbelem;
        return myarray[i];
    }

    public void set(int i, int o) {
    	assert i>=0;
    	assert i<nbelem;   	
        myarray[i] = o;
    }

    public boolean contains(int e) {
        for (int i=0;i<nbelem;i++) {
            if (myarray[i]==e)
                	return true;
        }
        return false;
    }
    /**
     * C'est op�rations devraient se faire en temps constant. Ce n'est pas le
     * cas ici.
     * 
     * @param copy
     */
    public void copyTo(IVecInt copy) {
        /*
         * int nsize = nbelem + copy.nbelem; copy.ensure(nsize); for (int i = 0;
         * i < nbelem; i++) { copy.myarray[i + copy.nbelem] = myarray[i]; }
         * copy.nbelem = nsize;
         */
    	VecInt ncopy = (VecInt)copy;
        int nsize = nbelem + ncopy.nbelem;
        ncopy.ensure(nsize);
        System.arraycopy(myarray, 0, ncopy.myarray, ncopy.nbelem, nbelem);
        ncopy.nbelem = nsize;
    }

    /**
     * @param is
     */
    public void copyTo(int[] is) {
        assert is.length>=nbelem;
        System.arraycopy(myarray, 0, is, 0, nbelem); 
    }

    /*
     * Copie un vecteur dans un autre (en vidant le premier), en temps
     * constant.
     */
    public void moveTo(IVecInt dest) {
        copyTo(dest);
        nbelem = 0;
    }

    public void moveTo2(IVecInt dest) {
    	VecInt ndest = (VecInt)dest;
        int s = ndest.nbelem;
        int tmp[] = ndest.myarray;
        ndest.myarray = myarray;
        ndest.nbelem = nbelem;
        myarray = tmp;
        nbelem = s;
        nbelem = 0;
    }

    public void moveTo(int[] dest) {
        System.arraycopy(myarray, 0, dest, 0, nbelem);
        nbelem = 0;
    }
    
	/**
	 * Insert an element at the very begining of the vector. The former first
	 * element is appended to the end of the vector in order to have a constant
	 * time operation.
	 * 
	 * @param elem
	 *            the element to put first in the vector.
	 */
	public void insertFirst(final int elem) {
		if (nbelem > 0) {
			push(myarray[0]);
			myarray[0] = elem;
			return;
		}
		push(elem);
	}
	
	/**
	 * Enleve un element qui se trouve dans le vecteur!!!
	 * 
	 * @param elem
	 *            un element du vecteur
	 */
	public void remove(int elem) {
		assert size() > 0;
		int j = 0;
		for (; myarray[j] != elem; j++) {
			assert j < size();
		}
		for (; j < size() - 1; j++) {
			myarray[j] = myarray[j + 1];
		}
		pop();
	}

    /**
     * Delete the ith element of the vector.
     * 
     * The latest element of the vector replaces the removed element
     * at the ith indexer.
     * 
     * @param i the indexer of the element in the vector
     * @return the former ith element of the vector that 
     * is now removed from the vector
     */
    public int delete(int i) {
       assert i>=0;
       assert i<nbelem;
       int ith = myarray[i];
       myarray[i]=myarray[--nbelem];
       return ith;
    }

    private int nbelem;

    private int[] myarray;

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.int#toString()
     */
    public String toString() {
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < nbelem - 1; i++) {
            stb.append(myarray[i]);
            stb.append(",");
        }
        if (nbelem>0) {
            stb.append(myarray[nbelem - 1]);
        }
        return stb.toString();
    }

    private static Random rand = new Random(RANDOM_SEED);

    void selectionSort(int from, int to) {
        int i, j, best_i;
        int tmp;

        for (i = from; i < to - 1; i++) {
            best_i = i;
            for (j = i + 1; j < to; j++) {
                if (myarray[j] < myarray[best_i]) best_i = j;
            }
            tmp = myarray[i];
            myarray[i] = myarray[best_i];
            myarray[best_i] = tmp;
        }
    }

    void sort(int from, int to) {
        int width = to - from;
        if (to - from <= 15)
            selectionSort(from, to);

        else {
            int pivot = myarray[rand.nextInt(width) + from];
            int tmp;
            int i = from - 1;
            int j = to;

            for (;;) {
                do
                    i++; while (myarray[i] < pivot);
                do
                    j--; while (pivot < myarray[j]);

                if (i >= j) break;

                tmp = myarray[i];
                myarray[i] = myarray[j];
                myarray[j] = tmp;
            }

            sort(from, i);
            sort(i, to);
        }
    }

    /**
     * @param comparator
     */
    public void sort() {
        sort(0, nbelem);
    }

    public void sortUnique() {
        int i, j;
        int last;
        if (nbelem==0) return;
        
        sort(0, nbelem);
        i = 1;
        last = myarray[0];
        for (j = 1; j < nbelem; j++) {
            if (last < myarray[j]) {
                last = myarray[i] = myarray[j];
                i++;
            }
        }

        nbelem = i;
    }


    /**
     * @uml property=DEFAULT_COMPARATOR changeability=frozen
     */
    /*
     * public final static Comparator DEFAULT_COMPARATOR = new Comparator() {
     * public int compare(int a, int b) { return ((Comparable) a).compareTo(b); }
     */

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object obj) {
        if (obj instanceof IVecInt) {
            IVecInt v = (IVecInt)obj;
            if (v.size()!=size()) return false;
            for(int i=0;i<size();i++) {
                if (v.get(i)!=get(i)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		int sum=0;
		for (int i=0;i<nbelem;i++) {
			sum += myarray.hashCode()/nbelem;
		}
		return sum;
	}
}
