/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Properties;
import org.sat4j.ExitCode;
import org.sat4j.Lanceur;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractLauncher
implements Serializable {
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String COMMENT_PREFIX = "c ";
    private long beginTime;
    private ExitCode exitCode = ExitCode.UNKNOWN;
    protected Reader reader;
    private transient PrintWriter out = new PrintWriter(System.out, true);
    private static final boolean cputimesupported = ManagementFactory.getThreadMXBean().isCurrentThreadCpuTimeSupported();
    protected transient Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            AbstractLauncher.this.displayResult();
        }
    };
    protected ISolver solver;
    private boolean silent = false;
    private double cputime;

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void displayResult() {
        if (this.solver != null) {
            double d = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
            this.solver.printStat(this.out, COMMENT_PREFIX);
            this.out.println(ANSWER_PREFIX + (Object)((Object)this.exitCode));
            if (this.exitCode == ExitCode.SATISFIABLE) {
                int[] nArray = this.solver.model();
                this.out.print(SOLUTION_PREFIX);
                this.reader.decode(nArray, this.out);
                this.out.println();
            }
            this.log("Total wall clock time (in seconds) : " + d);
            if (cputimesupported) {
                this.log("Total CPU time (experimental, in seconds) : " + this.cputime);
            }
        }
    }

    protected abstract void usage();

    protected final void displayHeader() throws IOException {
        Object object;
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2006 Daniel Le Berre");
        this.log("This is free software under the GNU LGPL licence. See www.sat4j.org for details.");
        this.log("This software uses some libraries from the Jakarta project. See jakarta.apache.org for details.");
        URL uRL = Lanceur.class.getResource("/sat4j.version");
        if (uRL == null) {
            this.log("no version file found!!!");
        } else {
            object = new BufferedReader(new InputStreamReader(uRL.openStream()));
            this.log("version " + ((BufferedReader)object).readLine());
            ((BufferedReader)object).close();
        }
        object = System.getProperties();
        String[] stringArray = new String[]{"sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        for (String string : stringArray) {
            this.log(string + "\t" + ((Properties)object).getProperty(string));
        }
        Runtime runtime = Runtime.getRuntime();
        this.log("Free memory " + runtime.freeMemory());
        this.log("Max memory " + runtime.maxMemory());
        this.log("Total memory " + runtime.totalMemory());
        this.log("Number of processors " + runtime.availableProcessors());
    }

    protected IProblem readProblem(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        this.log("solving " + string);
        this.log("reading problem ... ");
        this.reader = this.createReader(this.solver, string);
        IProblem iProblem = this.reader.parseInstance(string);
        this.log("... done. Wall clock time " + (double)(System.currentTimeMillis() - this.beginTime) / 1000.0 + "s.");
        if (cputimesupported) {
            this.log("CPU time (experimental) " + (double)ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1.0E9 + "s.");
        }
        this.log("#vars     " + this.solver.nVars());
        this.log("#constraints  " + this.solver.nConstraints());
        return iProblem;
    }

    protected abstract Reader createReader(ISolver var1, String var2);

    public void run(String[] stringArray) {
        try {
            this.displayHeader();
            this.solver = this.configureSolver(stringArray);
            if (this.solver == null) {
                return;
            }
            String string = this.getInstanceName(stringArray);
            this.beginTime = System.currentTimeMillis();
            IProblem iProblem = this.readProblem(string);
            try {
                this.solve(iProblem);
            }
            catch (TimeoutException timeoutException) {
                this.log("timeout");
            }
            if (cputimesupported) {
                this.cputime = (double)ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime() / 1.0E9;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("FATAL");
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            this.log("FATAL");
            iOException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            this.exitCode = ExitCode.UNSATISFIABLE;
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException parseFormatException) {
            this.log("FATAL");
            parseFormatException.printStackTrace();
        }
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    protected void log(String string) {
        if (!this.silent) {
            this.out.println(COMMENT_PREFIX + string);
        }
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        this.exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
    }

    public final void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ExitCode getExitCode() {
        return this.exitCode;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    protected void setSilent(boolean bl) {
        this.silent = bl;
    }
}

