/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        return SolverFactory.newMiniSAT2Heap();
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        Reader reader;
        if (string.endsWith(".txt")) {
            reader = new CSPExtSupportReader(iSolver);
        } else {
            assert (string.endsWith(".xml"));
            reader = new XMLCSPReader(iSolver);
        }
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            reader.setVerbosity(true);
        }
        return reader;
    }

    public static void main(String[] stringArray) {
        CSPLauncher cSPLauncher = new CSPLauncher();
        cSPLauncher.run(stringArray);
    }

    @Override
    protected void usage() {
        System.out.println("java -jar sat4jCSP instance-name");
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1);
        return stringArray[0];
    }
}

