/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.MinCostDecorator;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.opt.WeightedMaxSatDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.SolverDecorator;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of the solver to use");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        return options;
    }

    @Override
    protected void usage() {
        System.out.println("java -jar sat4jmax instance-name");
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        if (string.endsWith(".wcnf")) {
            return new DimacsReader(iSolver, "wcnf");
        }
        return new DimacsReader(iSolver);
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        SolverDecorator solverDecorator = null;
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
        } else {
            try {
                CommandLine commandLine = new PosixParser().parse(options, stringArray);
                String string = commandLine.getOptionValue("k");
                if (string == null) {
                    string = "maxsat";
                }
                if ("minone".equalsIgnoreCase(string)) {
                    solverDecorator = new MinOneDecorator(SolverFactory.newDefault());
                } else if ("mincost".equalsIgnoreCase(string)) {
                    solverDecorator = new MinCostDecorator(SolverFactory.newMiniOPBClauseCardConstrMax());
                } else {
                    assert ("maxsat".equalsIgnoreCase(string));
                    int n = stringArray.length - 1;
                    solverDecorator = stringArray[n].endsWith(".wcnf") ? new WeightedMaxSatDecorator(SolverFactory.newMiniOPBClauseCardConstrMax()) : new MaxSatDecorator(SolverFactory.newMini3SAT());
                }
                this.log(solverDecorator.toString("c "));
            }
            catch (ParseException parseException) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return solverDecorator;
    }

    public static void main(String[] stringArray) {
        GenericOptLauncher genericOptLauncher = new GenericOptLauncher();
        genericOptLauncher.run(stringArray);
    }
}

