/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractLauncher;
import org.sat4j.ExitCode;
import org.sat4j.Messages;
import org.sat4j.ResultCode;
import org.sat4j.ResultsManager;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.DotSearchListener;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class Lanceur
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    protected ASolverFactory factory;
    private String filename;
    private String resultsfile;
    private boolean update;
    private boolean replay;

    public static void main(String[] stringArray) {
        Lanceur lanceur = new Lanceur();
        lanceur.run(stringArray);
        System.exit(lanceur.getExitCode().value());
    }

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("l", "library", true, "specifies the name of the library used (minisat by default)");
        options.addOption("s", "solver", true, "specifies the name of a prebuilt solver from the library");
        options.addOption("S", "Solver", true, "setup a solver using a solver config string");
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("d", "dot", true, "create a sat4j.dot file in current directory representing the search");
        options.addOption("f", "filename", true, "specifies the file to use (in conjunction with -d for instance)");
        options.addOption("r", "replay", true, "replay stored results");
        options.addOption("b", "backup", true, "backup results in specified file");
        options.addOption("u", "update", false, "update results file if needed");
        options.addOption("m", "mute", false, "Set launcher in silent mode");
        Option option = options.getOption("l");
        option.setArgName("libname");
        option = options.getOption("s");
        option.setArgName("solvername");
        option = options.getOption("t");
        option.setArgName("delay");
        option = options.getOption("d");
        return options;
    }

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            return null;
        }
        try {
            Object object;
            Object object2;
            Serializable serializable;
            CommandLine commandLine = new PosixParser().parse(options, stringArray);
            String string = commandLine.getOptionValue("l");
            if (string == null) {
                string = "minisat";
            }
            assert ("minisat".equals(string) || "ubcsat".equals(string));
            try {
                serializable = Class.forName("org.sat4j." + string + ".SolverFactory");
                object2 = new Class[]{};
                object = ((Class)serializable).getMethod("instance", (Class<?>)object2);
                this.factory = (ASolverFactory)((Method)object).invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getString("Lanceur.wrong.framework"));
                exception.printStackTrace();
            }
            serializable = commandLine.hasOption("S") ? this.configureFromString(commandLine.getOptionValue("S")) : ((object2 = commandLine.getOptionValue("s")) == null ? this.factory.defaultSolver() : this.factory.createSolverByName((String)object2));
            object2 = commandLine.getOptionValue("t");
            if (object2 == null) {
                object2 = commandLine.getOptionValue("T");
                if (object2 != null) {
                    serializable.setTimeoutMs(Long.parseLong((String)object2));
                }
            } else {
                serializable.setTimeout(Integer.parseInt((String)object2));
            }
            this.filename = commandLine.getOptionValue("f");
            if (commandLine.hasOption("d")) {
                object = null;
                if (this.filename != null) {
                    object = commandLine.getOptionValue("d");
                }
                if (object == null) {
                    object = "sat4j.dot";
                }
                ((Solver)serializable).setSearchListener(new DotSearchListener((String)object));
            }
            if (commandLine.hasOption("m")) {
                this.setSilent(true);
            }
            int n = 0;
            String[] stringArray2 = commandLine.getArgs();
            if (this.filename == null) {
                this.filename = stringArray2[n++];
            }
            this.update = commandLine.hasOption("u");
            this.resultsfile = commandLine.getOptionValue("r");
            if (this.resultsfile == null) {
                this.replay = false;
                this.resultsfile = commandLine.getOptionValue("b");
            } else {
                this.replay = true;
            }
            while (n < stringArray2.length) {
                String[] stringArray3 = stringArray2[n].split("=");
                assert (stringArray3.length == 2);
                this.log("setting " + stringArray3[0] + " to " + stringArray3[1]);
                try {
                    BeanUtils.setProperty(serializable, stringArray3[0], stringArray3[1]);
                }
                catch (Exception exception) {
                    this.log("Cannot set parameter : " + stringArray[n]);
                }
                ++n;
            }
            this.log(serializable.toString("c "));
            this.log("timeout: " + serializable.getTimeout() + "s");
            return serializable;
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j.jar", options, true);
            this.usage();
            return null;
        }
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        return new InstanceReader(iSolver);
    }

    @Override
    public void run(String[] stringArray) {
        if (this.replay) {
            try {
                this.displayHeader();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.solver = this.configureSolver(stringArray);
            if (this.solver == null) {
                return;
            }
            this.runValidationFile(this.solver, this.resultsfile, this.update);
        } else {
            super.run(stringArray);
        }
    }

    void showAvailableSolvers() {
        if (this.factory != null) {
            this.log("Available solvers: ");
            String[] stringArray = this.factory.solverNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.log(stringArray[i]);
            }
        }
    }

    @Override
    protected void usage() {
        this.showAvailableSolvers();
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        return this.filename;
    }

    private final void stockValidationFile(ISolver iSolver, String string, String string2, boolean bl) {
        try {
            if (bl) {
                new FileWriter(string2, true).close();
            }
            ResultsManager resultsManager = new ResultsManager(string2, bl);
            ExitCode exitCode = ExitCode.UNKNOWN;
            Reader reader = this.createReader(iSolver, string);
            IProblem iProblem = reader.parseInstance(string);
            exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
            ResultCode resultCode = resultsManager.compare(string, exitCode);
            this.getLogWriter().println(ResultsManager.printLine(string, exitCode, resultCode));
            if (bl && resultCode != ResultCode.KO && resultCode != ResultCode.WARNING) {
                resultsManager.save(string2);
                System.out.println("File Saved As <" + string2 + ">");
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ParseFormatException parseFormatException) {
            parseFormatException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            contradictionException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
    }

    private void runValidationFile(ISolver iSolver, String string, boolean bl) {
        try {
            ResultsManager resultsManager = new ResultsManager(string, bl);
            int[] nArray = new int[ResultCode.values().length + 1];
            for (String string2 : resultsManager.getFiles()) {
                ExitCode exitCode = ExitCode.UNKNOWN;
                Reader reader = this.createReader(iSolver, string2);
                try {
                    IProblem iProblem = reader.parseInstance(string2);
                    exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
                }
                catch (FileNotFoundException parseFormatException) {
                    this.log("FATAL " + parseFormatException.getMessage());
                }
                catch (ParseFormatException iOException) {
                    this.log("FATAL " + iOException.getMessage());
                }
                catch (IOException contradictionException) {
                    this.log("FATAL " + contradictionException.getMessage());
                }
                catch (ContradictionException timeoutException) {
                    this.log("Trivial inconsistency");
                    exitCode = ExitCode.UNSATISFIABLE;
                }
                catch (TimeoutException timeoutException) {
                    this.log("Timeout");
                }
                ResultCode fileNotFoundException = resultsManager.compare(string2, exitCode);
                int n = fileNotFoundException.getValue();
                nArray[n] = nArray[n] + 1;
                this.getLogWriter().println(ResultsManager.printLine(string2, exitCode, fileNotFoundException));
            }
            this.getLogWriter().println(Lanceur.getSummary(nArray));
            if (bl && Lanceur.getSuccess(nArray)) {
                String string3 = ResultsManager.createPath() + "." + "WXP".toLowerCase(Locale.getDefault());
                resultsManager.save(string3);
                System.out.println("File Saved As <" + new File(string3).getCanonicalPath() + ">");
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final boolean getSuccess(int[] nArray) {
        return nArray[ResultCode.KO.getValue()] <= 0 && nArray[ResultCode.WARNING.getValue()] <= 0;
    }

    private static final String getSummary(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("\n\nValidation Tests ");
        if (Lanceur.getSuccess(nArray)) {
            stringBuffer.append("Success");
        } else {
            stringBuffer.append("Failed");
        }
        stringBuffer.append("\nsummary : number of OKs ");
        stringBuffer.append(nArray[ResultCode.OK.getValue()]);
        stringBuffer.append("\n          number of KOs ");
        stringBuffer.append(nArray[ResultCode.KO.getValue()]);
        stringBuffer.append("\n          number of WARNINGs ");
        stringBuffer.append(nArray[ResultCode.WARNING.getValue()]);
        stringBuffer.append("\n          number of UPDATEDs ");
        stringBuffer.append(nArray[ResultCode.UPDATED.getValue()]);
        stringBuffer.append("\n          number of UNKNOWNs ");
        stringBuffer.append(nArray[ResultCode.UNKNOWN.getValue()]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private final ISolver configureFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Properties properties = new Properties();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = string2.split("=");
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        DataStructureFactory dataStructureFactory = this.setupObject("DSF", properties, new MixedDataStructureDaniel());
        LearningStrategy learningStrategy = this.setupObject("LEARNING", properties, new LimitedLearning());
        IOrder iOrder = this.setupObject("ORDER", properties, new VarOrderHeap());
        Solver solver = new Solver(new FirstUIP(), learningStrategy, dataStructureFactory, iOrder);
        learningStrategy.setSolver(solver);
        solver.setSimplifier(properties.getProperty("SIMP", "NO_SIMPLIFICATION"));
        SearchParams searchParams = this.setupObject("PARAMS", properties, new SearchParams());
        solver.setSearchParams(searchParams);
        return solver;
    }

    private final <T> T setupObject(String string, Properties properties, T t) {
        try {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                this.log("using default component " + t + " for " + string);
                return t;
            }
            this.log("configuring " + string);
            String[] stringArray = string2.split("/");
            Object obj = Class.forName(stringArray[0]).newInstance();
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                assert (stringArray2.length == 2);
                try {
                    BeanUtils.getProperty(obj, stringArray2[0]);
                    BeanUtils.setProperty(obj, stringArray2[0], stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    this.log("Problem with component " + stringArray[0] + " " + exception);
                }
            }
            return (T)obj;
        }
        catch (InstantiationException instantiationException) {
            this.log("Problem with component " + string + " " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log("Problem with component " + string + " " + illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log("Problem with component " + string + " " + classNotFoundException);
        }
        this.log("using default component " + t + " for " + string);
        return t;
    }
}

