/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.orders.VarOrderHeapObjective;
import org.sat4j.opt.PseudoOptDecorator;
import org.sat4j.reader.OPBReader2005;
import org.sat4j.reader.OPBReader2006;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.reader.Reader;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public class LanceurPseudo2005
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;
    protected ObjectiveFunction obfct;

    public static void main(String[] stringArray) {
        LanceurPseudo2005 lanceurPseudo2005 = new LanceurPseudo2005();
        lanceurPseudo2005.run(stringArray);
        System.exit(lanceurPseudo2005.getExitCode().value());
    }

    @Override
    protected Reader createReader(ISolver iSolver, String string) {
        return new OPBReader2006(iSolver);
    }

    @Override
    protected void solve(IProblem iProblem) throws TimeoutException {
        ObjectiveFunction objectiveFunction = ((OPBReader2005)this.getReader()).getObjectiveFunction();
        ((PseudoOptDecorator)iProblem).setObjectTiveFunction(objectiveFunction);
        IOrder iOrder = ((Solver)((PseudoOptDecorator)iProblem).decorated()).getOrder();
        if (iOrder instanceof VarOrderHeapObjective) {
            ((VarOrderHeapObjective)iOrder).setObjectiveFunction(objectiveFunction);
        }
        super.solve(iProblem);
    }

    @Override
    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver = stringArray.length > 1 ? SolverFactory.instance().createSolverByName(stringArray[0]) : SolverFactory.newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncremental();
        iSolver = new PseudoOptDecorator(iSolver);
        iSolver.setTimeout(Integer.MAX_VALUE);
        System.out.println(iSolver.toString("c "));
        return iSolver;
    }

    @Override
    protected void usage() {
        System.out.println("java -jar sat4jPseudo instancename.opb");
    }

    @Override
    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1 || stringArray.length == 2);
        return stringArray[stringArray.length - 1];
    }
}

