/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.sat4j.ExitCode;
import org.sat4j.ResultCode;

public class ResultsManager {
    public static final String SEPARATOR = "=";
    public static final String EXT_JU = "WXP";
    public static final String COMMENT = "#";
    private final String wxpFileName;
    private final Map<String, ExitCode> files;
    private final boolean save;

    public ResultsManager(String string, boolean bl) throws MalformedURLException, IOException {
        this.wxpFileName = string;
        this.save = bl;
        this.files = ResultsManager.getInformations(string);
    }

    public final ResultCode compare(String string, ExitCode exitCode) {
        ExitCode exitCode2 = this.files.get(string);
        ExitCode exitCode3 = exitCode2 == null ? ExitCode.UNKNOWN : exitCode2;
        ResultCode resultCode = this.computeResultCode(exitCode3, exitCode);
        if (this.save && resultCode.equals((Object)ResultCode.UPDATED)) {
            this.files.put(string, exitCode);
        }
        return resultCode;
    }

    public final void save() throws IOException {
        this.save(this.wxpFileName);
    }

    public String[] getFiles() {
        return this.files.keySet().toArray(new String[0]);
    }

    public final void save(String string) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(this.getFileDescription());
        fileWriter.close();
    }

    private final String getFileDescription() {
        StringBuffer stringBuffer = new StringBuffer("#Evaluation : ");
        stringBuffer.append("\n\n");
        for (String string : this.files.keySet()) {
            stringBuffer.append(string);
            stringBuffer.append(SEPARATOR);
            stringBuffer.append((Object)this.files.get(string));
            stringBuffer.append('\n');
        }
        stringBuffer.append("\n\n#Evaluation END");
        return stringBuffer.toString();
    }

    private final ResultCode computeResultCode(ExitCode exitCode, ExitCode exitCode2) {
        if (exitCode.equals((Object)exitCode2)) {
            return ResultCode.OK;
        }
        if (ExitCode.UNKNOWN.equals((Object)exitCode) && (ExitCode.UNSATISFIABLE.equals((Object)exitCode2) || ExitCode.SATISFIABLE.equals((Object)exitCode2))) {
            return ResultCode.UPDATED;
        }
        if ((ExitCode.UNSATISFIABLE.equals((Object)exitCode) || ExitCode.SATISFIABLE.equals((Object)exitCode)) && ExitCode.UNKNOWN.equals((Object)exitCode2)) {
            return ResultCode.WARNING;
        }
        if (ExitCode.SATISFIABLE.equals((Object)exitCode) && ExitCode.UNSATISFIABLE.equals((Object)exitCode2) || ExitCode.UNSATISFIABLE.equals((Object)exitCode) && ExitCode.SATISFIABLE.equals((Object)exitCode2)) {
            return ResultCode.KO;
        }
        return ResultCode.UNKNOWN;
    }

    public static final Map<String, ExitCode> getInformations(URL uRL) throws IOException {
        return ResultsManager.getInformations(new InputStreamReader(uRL.openStream()));
    }

    public static final Map<String, ExitCode> getInformations(String string) throws MalformedURLException, IOException {
        if (string.startsWith("http://")) {
            return ResultsManager.getInformations(new URL(string));
        }
        return ResultsManager.getInformations(new FileReader(string));
    }

    public static final Map<String, ExitCode> getInformations(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        HashMap<String, ExitCode> hashMap = new HashMap<String, ExitCode>();
        String string = null;
        int n = 1;
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                if (!"".equals(string.trim()) && !string.trim().startsWith(COMMENT)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATOR);
                    if (stringTokenizer.countTokens() == 2) {
                        hashMap.put(stringTokenizer.nextToken(), ExitCode.valueOf(stringTokenizer.nextToken()));
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("File Parsing Error in line " + n + "\nError caused by : " + string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return hashMap;
    }

    public static final String printLine(String string, ExitCode exitCode, ResultCode resultCode) {
        return string + SEPARATOR + exitCode.toString() + " [" + resultCode.toString() + "]";
    }

    public static final String createPath() {
        StringBuffer stringBuffer = new StringBuffer("Eval_");
        stringBuffer.append(Calendar.getInstance().getTime().toString().replace(" ", "_").replace(":", "_"));
        return stringBuffer.toString();
    }
}

