/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat;

import java.io.Serializable;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.CardinalityDataStructure;
import org.sat4j.minisat.constraints.ClausalDataStructureCB;
import org.sat4j.minisat.constraints.ClausalDataStructureCBWL;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinary;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinaryAndTernary;
import org.sat4j.minisat.constraints.PBMaxCBClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMaxDataStructure;
import org.sat4j.minisat.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PBMinDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.minisat.constraints.PuebloPBMinDataStructure;
import org.sat4j.minisat.constraints.pb.PBSolver;
import org.sat4j.minisat.constraints.pb.PBSolverClause;
import org.sat4j.minisat.constraints.pb.PBSolverWithImpliedClause;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ActiveLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.LimitedLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.JWOrder;
import org.sat4j.minisat.orders.MyOrder;
import org.sat4j.minisat.orders.PureOrder;
import org.sat4j.minisat.orders.VarOrder;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.orders.VarOrderHeapObjective;
import org.sat4j.minisat.uip.DecisionUIP;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

public class SolverFactory
extends ASolverFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static ISolver newMiniLearning() {
        return SolverFactory.newMiniLearning(10);
    }

    public static ISolver newMiniLearningHeap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningHeapEZSimp() {
        Solver solver = (Solver)SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapExpSimp() {
        Solver solver = (Solver)SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearning(int n) {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), n);
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, 10);
    }

    public static ISolver newMiniLearningHeap(DataStructureFactory dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, new VarOrderHeap());
    }

    public static ISolver newMiniLearning2() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning2Heap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniLearning23() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniLearningCB() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCB());
    }

    public static ISolver newMiniLearningCBWL() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCBWL());
    }

    public static ISolver newMiniLearning2NewOrder() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureWithBinary(), new MyOrder());
    }

    public static ISolver newMiniLearningPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new MixedDataStructureDaniel(), new PureOrder());
    }

    public static ISolver newMiniLearningCBWLPure() {
        return SolverFactory.newMiniLearning((DataStructureFactory)new ClausalDataStructureCBWL(), new PureOrder());
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory, int n) {
        LimitedLearning limitedLearning = new LimitedLearning(n);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, new VarOrder());
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearning(DataStructureFactory dataStructureFactory, IOrder iOrder) {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, iOrder);
        limitedLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniLearningEZSimp() {
        return SolverFactory.newMiniLearningEZSimp(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniLearningEZSimp(DataStructureFactory dataStructureFactory) {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, dataStructureFactory, new VarOrder());
        limitedLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapEZSimpNoRestarts() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap());
        limitedLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniLearningHeapEZSimpLongRestarts() {
        LimitedLearning limitedLearning = new LimitedLearning(10);
        Solver solver = new Solver(new FirstUIP(), limitedLearning, new MixedDataStructureDaniel(), new SearchParams(1000), new VarOrderHeap());
        limitedLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newActiveLearning() {
        ActiveLearning activeLearning = new ActiveLearning();
        Solver solver = new Solver(new FirstUIP(), activeLearning, new MixedDataStructureDaniel(), new VarOrder());
        activeLearning.setOrder(solver.getOrder());
        activeLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMiniSAT() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATNoRestarts() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrder());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSAT2() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSAT(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrder());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniSATHeap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureDaniel());
    }

    public static ISolver newMiniSATHeapEZSimp() {
        Solver solver = (Solver)SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniSATHeapExpSimp() {
        Solver solver = (Solver)SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static ISolver newMiniSAT2Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinary());
    }

    public static ISolver newMiniSAT23Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinaryAndTernary());
    }

    public static ISolver newMiniSATHeap(DataStructureFactory dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniCard() {
        return SolverFactory.newMiniSAT(new CardinalityDataStructure());
    }

    public static ISolver newMinimalOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBClauseCardConstrMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxSpecificOrder() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncremental() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMinimalOPBClauseCardConstrMaxSpecificOrder() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxReduceToClause() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverClause pBSolverClause = new PBSolverClause(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverClause.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverClause);
        return pBSolverClause;
    }

    public static ISolver newMiniOPBClauseCardConstrMaxImplied() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolverWithImpliedClause pBSolverWithImpliedClause = new PBSolverWithImpliedClause(new FirstUIP(), miniSATLearning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolverWithImpliedClause.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolverWithImpliedClause);
        return pBSolverWithImpliedClause;
    }

    public static ISolver newMiniOPBClauseAtLeastConstrMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBCounterBasedClauseCardConstrMax() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMaxCBClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMinimalOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMinimalOPBMinPueblo() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new PuebloPBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMiniOPBMinPueblo() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PuebloPBMinDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBClauseCardMinPueblo() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PuebloPBMinClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBClauseCardMin() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PBMinClauseCardConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newMiniOPBClauseAtLeastMinPueblo() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        PBSolver pBSolver = new PBSolver(new FirstUIP(), miniSATLearning, new PuebloPBMinClauseAtLeastConstrDataStructure(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(pBSolver.getDSFactory());
        miniSATLearning.setVarActivityListener(pBSolver);
        return pBSolver;
    }

    public static ISolver newRelsat() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new DecisionUIP(), miniSATLearning, new MixedDataStructureDaniel(), new VarOrderHeap());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newBackjumping() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        Solver solver = new Solver(new FirstUIP(), noLearningButHeuristics, new MixedDataStructureDaniel(), new VarOrderHeap());
        noLearningButHeuristics.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMini3SAT() {
        FixedLengthLearning fixedLengthLearning = new FixedLengthLearning(3);
        Solver solver = new Solver(new FirstUIP(), fixedLengthLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new JWOrder());
        fixedLengthLearning.setSolver(solver);
        return solver;
    }

    public static ISolver newMini3SATb() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new JWOrder());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newDefault() {
        return SolverFactory.newMiniLearningHeapExpSimp();
    }

    @Override
    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ISolver newLight() {
        return SolverFactory.newMini3SAT();
    }

    @Override
    public ISolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }
}

