/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.AbstractPBDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.WLClause;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public abstract class AbstractPBClauseCardConstrDataStructure
extends AbstractPBDataStructureFactory {
    private static final BigInteger MAX_INT_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return this.constraintFactory(iVecInt, WatchPb.toVecBigInt(iVecInt2), bl, WatchPb.toBigInt(n));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVecInt iVecInt2, int n) {
        return this.constraintFactory(iVecInt, WatchPb.toVecBigInt(iVecInt2), WatchPb.toBigInt(n));
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IDataStructurePB iDataStructurePB = WatchPb.niceParameters(iVecInt, iVec, bl, bigInteger, this.getVocabulary());
        if (iDataStructurePB == null) {
            return null;
        }
        int n = iDataStructurePB.size();
        int[] nArray = new int[n];
        BigInteger[] bigIntegerArray = new BigInteger[n];
        iDataStructurePB.buildConstraintFromMapPb(nArray, bigIntegerArray);
        if (iDataStructurePB.getDegree().equals(BigInteger.ONE)) {
            IVecInt iVecInt2 = WLClause.sanityCheck(new VecInt(nArray), this.getVocabulary(), this.solver);
            if (iVecInt2 == null) {
                return null;
            }
            return this.constructClause(iVecInt2);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(new Vec<BigInteger>(bigIntegerArray))) {
            assert (iDataStructurePB.getDegree().compareTo(MAX_INT_VALUE) < 0);
            return this.constructCard(new VecInt(nArray), iDataStructurePB.getDegree().intValue());
        }
        return this.constructPB(iDataStructurePB);
    }

    @Override
    protected PBConstr constraintFactory(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return this.constructLearntClause(iVecInt);
        }
        if (AbstractPBClauseCardConstrDataStructure.coefficientsEqualToOne(iVec)) {
            return this.constructLearntCard(iVecInt, bigInteger.intValue());
        }
        return this.constructLearntPB(iVecInt, iVec, bigInteger);
    }

    private static boolean coefficientsEqualToOne(IVec<BigInteger> iVec) {
        for (int i = 0; i < iVec.size(); ++i) {
            if (iVec.get(i).equals(BigInteger.ONE)) continue;
            return false;
        }
        return true;
    }

    protected abstract PBConstr constructClause(IVecInt var1);

    protected abstract PBConstr constructCard(IVecInt var1, int var2) throws ContradictionException;

    protected abstract PBConstr constructPB(IDataStructurePB var1) throws ContradictionException;

    protected abstract PBConstr constructLearntClause(IVecInt var1);

    protected abstract PBConstr constructLearntCard(IVecInt var1, int var2);

    protected abstract PBConstr constructLearntPB(IVecInt var1, IVec<BigInteger> var2, BigInteger var3);
}

