/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class CBClause
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int falsified;
    private boolean learnt;
    protected final int[] lits;
    protected final ILits voc;
    private double activity;

    public static CBClause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt) {
        CBClause cBClause = new CBClause(iVecInt, iLits);
        cBClause.register();
        return cBClause;
    }

    public CBClause(IVecInt iVecInt, ILits iLits, boolean bl) {
        this.learnt = bl;
        this.lits = new int[iVecInt.size()];
        this.voc = iLits;
        iVecInt.moveTo(this.lits);
    }

    public CBClause(IVecInt iVecInt, ILits iLits) {
        this(iVecInt, iLits, false);
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    @Override
    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.undos(n).push(this);
        ++this.falsified;
        assert (this.falsified != this.lits.length);
        if (this.falsified == this.lits.length - 1) {
            for (int i = 0; i < this.lits.length; ++i) {
                if (this.voc.isFalsified(this.lits[i])) continue;
                return unitPropagationListener.enqueue(this.lits[i], this);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean simplify() {
        for (int n : this.lits) {
            if (!this.voc.isSatisfied(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void undo(int n) {
        --this.falsified;
    }

    @Override
    public void calcReason(int n, IVecInt iVecInt) {
        assert (iVecInt.size() == 0);
        for (int n2 : this.lits) {
            assert (this.voc.isFalsified(n2) || n2 == n);
            if (!this.voc.isFalsified(n2)) continue;
            iVecInt.push(n2 ^ 1);
        }
        assert (n == -1 || iVecInt.size() == this.lits.length - 1);
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public void incActivity(double d) {
        this.activity += d;
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    @Override
    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public void register() {
        for (int n : this.lits) {
            this.voc.watch(n ^ 1, this);
        }
        if (this.learnt) {
            for (int n : this.lits) {
                if (!this.voc.isFalsified(n)) continue;
                this.voc.undos(n ^ 1).push(this);
                ++this.falsified;
            }
            assert (this.falsified == this.lits.length - 1);
        }
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    @Override
    public int size() {
        return this.lits.length;
    }

    @Override
    public int get(int n) {
        return this.lits[n];
    }

    @Override
    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        assert (this.voc.isUnassigned(this.lits[0]));
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        assert (bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lits.length; ++i) {
            stringBuffer.append(this.lits[i]);
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[i]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

