/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public class TernaryClauses
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IVecInt stubs = new VecInt();
    private final ILits voc;
    private final int phead;

    public TernaryClauses(ILits iLits, int n) {
        this.voc = iLits;
        this.phead = n;
    }

    public void addTernaryClause(int n, int n2) {
        this.stubs.push(n);
        this.stubs.push(n2);
    }

    @Override
    public void remove() {
    }

    @Override
    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        assert (this.voc.isSatisfied(n));
        assert (this.voc.isFalsified(this.phead));
        this.voc.watch(n, this);
        for (int i = 0; i < this.stubs.size(); i += 2) {
            int n2 = this.stubs.get(i);
            int n3 = this.stubs.get(i + 1);
            if (this.voc.isSatisfied(n2) || this.voc.isSatisfied(n3)) continue;
            if (this.voc.isFalsified(n2) && !unitPropagationListener.enqueue(n3, this)) {
                return false;
            }
            if (!this.voc.isFalsified(n3) || unitPropagationListener.enqueue(n2, this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean simplify() {
        return false;
    }

    public void undo(int n) {
    }

    @Override
    public void calcReason(int n, IVecInt iVecInt) {
        assert (this.voc.isFalsified(this.phead));
        if (n == -1) {
            int n2 = 0;
            while (!this.voc.isFalsified(this.stubs.get(n2)) || !this.voc.isFalsified(this.stubs.get(n2 + 1))) {
                n2 += 2;
            }
            iVecInt.push(this.phead ^ 1);
            iVecInt.push(this.stubs.get(n2) ^ 1);
            iVecInt.push(this.stubs.get(n2 + 1) ^ 1);
        } else {
            iVecInt.push(this.phead ^ 1);
            int n3 = 0;
            while (this.stubs.get(n3) != n || !this.voc.isFalsified(this.stubs.get(n3 ^ 1))) {
                ++n3;
            }
            assert (!this.voc.isFalsified(this.stubs.get(n3)));
            iVecInt.push(this.stubs.get(n3 ^ 1) ^ 1);
            assert (this.voc.isFalsified(this.stubs.get(n3 ^ 1)));
        }
    }

    @Override
    public boolean learnt() {
        return false;
    }

    @Override
    public void incActivity(double d) {
    }

    @Override
    public double getActivity() {
        return 0.0;
    }

    @Override
    public boolean locked() {
        return false;
    }

    @Override
    public void setLearnt() {
    }

    @Override
    public void register() {
    }

    @Override
    public void rescaleBy(double d) {
    }

    @Override
    public int size() {
        return this.stubs.size();
    }

    @Override
    public int get(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }
}

