/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.MapPb;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr pBConstr, int n) {
        HashMap<Integer, BigInteger> hashMap = new HashMap<Integer, BigInteger>();
        for (int i = 0; i < pBConstr.size(); ++i) {
            int n2 = pBConstr.get(i);
            BigInteger bigInteger = pBConstr.getCoef(i);
            assert (pBConstr.get(i) != 0);
            assert (pBConstr.getCoef(i).signum() > 0);
            hashMap.put(n2, bigInteger);
        }
        return new ConflictMap(hashMap, pBConstr.getDegree(), pBConstr.getVocabulary(), n);
    }

    ConflictMap(Map<Integer, BigInteger> map, BigInteger bigInteger, ILits iLits, int n) {
        super(map, bigInteger);
        this.voc = iLits;
        this.currentLevel = n;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        for (Integer n : this.coefs.keySet()) {
            int n2;
            int n3 = n;
            int n4 = this.voc.getLevel(n3);
            BigInteger bigInteger = (BigInteger)this.coefs.get(n);
            if (!(bigInteger.signum() <= 0 || this.voc.isFalsified(n3) && n4 != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(bigInteger);
            }
            if (this.byLevel[n2 = ConflictMap.levelToIndex(n4)] == null) {
                this.byLevel[n2] = new VecInt();
            }
            this.byLevel[n2].push(n3);
        }
    }

    private static final int levelToIndex(int n) {
        return n + 1;
    }

    private static final int indexToLevel(int n) {
        return n - 1;
    }

    @Override
    public BigInteger resolve(PBConstr pBConstr, int n, VarActivityListener varActivityListener) {
        assert (n > 1);
        int n2 = n ^ 1;
        if (!this.coefs.containsKey(n2)) {
            if (this.coefs.containsKey(n)) {
                assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].contains(n));
                this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].remove(n);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(n);
                if (this.voc.isFalsified(n)) {
                    this.currentSlack = this.currentSlack.add((BigInteger)this.coefs.get(n));
                }
            }
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] bigIntegerArray = null;
        BigInteger bigInteger = pBConstr.getDegree();
        int n3 = 0;
        while (pBConstr.get(n3) != n) {
            ++n3;
        }
        assert (pBConstr.get(n3) == n);
        assert (pBConstr.getCoef(n3) != BigInteger.ZERO);
        if (pBConstr.getCoef(n3).equals(BigInteger.ONE)) {
            this.coefMultCons = (BigInteger)this.coefs.get(n2);
            this.coefMult = BigInteger.ONE;
            bigInteger = bigInteger.multiply(this.coefMultCons);
        } else {
            if (((BigInteger)this.coefs.get(n2)).equals(BigInteger.ONE)) {
                this.coefMult = pBConstr.getCoef(n3);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                WatchPb watchPb = (WatchPb)pBConstr;
                bigIntegerArray = watchPb.getCoefs();
                assert (this.positiveCoefs(bigIntegerArray));
                bigInteger = this.reduceUntilConflict(n, n3, bigIntegerArray, watchPb);
                bigInteger = bigInteger.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            for (Integer n4 : this.coefs.keySet()) {
                this.setCoef(n4, ((BigInteger)this.coefs.get(n4)).multiply(this.coefMult));
            }
        }
        this.degree = this.cuttingPlane(pBConstr, bigInteger, bigIntegerArray, this.coefMultCons, varActivityListener);
        assert (!this.coefs.containsKey(n));
        assert (!this.coefs.containsKey(n2));
        assert (this.getLevelByLevel(n) == -1);
        assert (this.getLevelByLevel(n2) == -1);
        assert (this.degree.signum() > 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int n, int n2, BigInteger[] bigIntegerArray, WatchPb watchPb) {
        BigInteger bigInteger = BigInteger.ONE.negate();
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ZERO;
        BigInteger bigInteger4 = watchPb.getDegree();
        do {
            BigInteger bigInteger5;
            if (bigInteger.signum() >= 0) {
                assert (bigInteger2.signum() > 0);
                bigInteger5 = this.reduceInConstraint(watchPb, bigIntegerArray, n2, bigInteger4);
                assert (bigInteger5.compareTo(bigInteger4) < 0 && bigInteger5.compareTo(BigInteger.ONE) >= 0);
                bigInteger4 = bigInteger5;
            }
            assert (((BigInteger)this.coefs.get(n ^ 1)).signum() > 0);
            assert (bigIntegerArray[n2].signum() > 0);
            bigInteger5 = (BigInteger)this.coefs.get(n ^ 1);
            BigInteger bigInteger6 = ConflictMap.ppcm(bigIntegerArray[n2], bigInteger5);
            assert (bigInteger6.signum() > 0);
            this.coefMult = bigInteger6.divide(bigInteger5);
            this.coefMultCons = bigInteger6.divide(bigIntegerArray[n2]);
            assert (this.coefMultCons.signum() > 0);
            assert (this.coefMult.signum() > 0);
            assert (this.coefMult.multiply(bigInteger5).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
            bigInteger2 = watchPb.slackConstraint(bigIntegerArray, bigInteger4).multiply(this.coefMultCons);
            bigInteger3 = this.slackConflict().multiply(this.coefMult);
            assert (bigInteger3.signum() <= 0);
        } while ((bigInteger = bigInteger2.add(bigInteger3)).signum() >= 0);
        assert (this.coefMult.multiply((BigInteger)this.coefs.get(n ^ 1)).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
        return bigInteger4;
    }

    @Override
    public BigInteger slackConflict() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (Integer n : this.coefs.keySet()) {
            BigInteger bigInteger2 = (BigInteger)this.coefs.get(n);
            if (bigInteger2.signum() == 0 || this.voc.isFalsified(n)) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger.subtract(this.degree);
    }

    public boolean oldIsAssertive(int n) {
        BigInteger bigInteger = this.computeSlack(n).subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        for (Integer n2 : this.coefs.keySet()) {
            BigInteger bigInteger2 = (BigInteger)this.coefs.get(n2);
            if (bigInteger2.signum() <= 0 || !this.voc.isUnassigned(n2) && this.voc.getLevel(n2) < n || bigInteger.compareTo(bigInteger2) >= 0) continue;
            return true;
        }
        return false;
    }

    private BigInteger computeSlack(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (Integer n2 : this.coefs.keySet()) {
            BigInteger bigInteger2 = (BigInteger)this.coefs.get(n2);
            if (bigInteger2.signum() <= 0 || this.voc.isFalsified(n2) && this.voc.getLevel(n2) < n) continue;
            bigInteger = bigInteger.add(bigInteger2);
        }
        return bigInteger;
    }

    @Override
    public boolean isAssertive(int n) {
        assert (n <= this.currentLevel);
        assert (n <= this.currentLevel);
        this.currentLevel = n;
        BigInteger bigInteger = this.currentSlack.subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(n, bigInteger);
    }

    private boolean isImplyingLiteral(int n, BigInteger bigInteger) {
        int n2 = ConflictMap.levelToIndex(-1);
        if (this.byLevel[n2] != null) {
            for (Integer n3 : this.byLevel[n2]) {
                if (bigInteger.compareTo((BigInteger)this.coefs.get(n3)) >= 0) continue;
                return true;
            }
        }
        for (int i = ConflictMap.levelToIndex(n); i < this.byLevel.length; ++i) {
            if (this.byLevel[i] == null) continue;
            for (Integer n4 : this.byLevel[i]) {
                BigInteger bigInteger2 = (BigInteger)this.coefs.get(n4);
                if (bigInteger2 == null || bigInteger.compareTo(bigInteger2) >= 0) continue;
                return true;
            }
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    @Override
    public BigInteger reduceInConstraint(WatchPb watchPb, BigInteger[] bigIntegerArray, int n, BigInteger bigInteger) {
        int n2;
        int n3;
        assert (bigInteger.compareTo(BigInteger.ONE) > 0);
        int n4 = -1;
        for (n3 = 0; n3 < watchPb.lits.length && n4 == -1; ++n3) {
            if (bigIntegerArray[n3].signum() == 0 || !this.voc.isUnassigned(watchPb.lits[n3])) continue;
            assert (bigIntegerArray[n3].compareTo(bigInteger) < 0);
            n4 = n3;
        }
        if (n4 == -1) {
            for (n3 = 0; n3 < watchPb.lits.length && n4 == -1; ++n3) {
                if (bigIntegerArray[n3].signum() == 0 || !this.voc.isSatisfied(watchPb.lits[n3]) || n3 == n) continue;
                n4 = n3;
            }
        }
        assert (n4 != -1);
        assert (n4 != n);
        BigInteger bigInteger2 = bigInteger.subtract(bigIntegerArray[n4]);
        bigIntegerArray[n4] = BigInteger.ZERO;
        assert (bigInteger2.signum() > 0);
        BigInteger bigInteger3 = bigInteger2;
        for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
            if (bigIntegerArray[n2].signum() > 0) {
                bigInteger3 = bigInteger3.min(bigIntegerArray[n2]);
            }
            bigIntegerArray[n2] = bigInteger2.min(bigIntegerArray[n2]);
        }
        if (bigInteger3.equals(bigInteger2) && !bigInteger2.equals(BigInteger.ONE)) {
            bigInteger2 = BigInteger.ONE;
            for (n2 = 0; n2 < bigIntegerArray.length; ++n2) {
                if (bigIntegerArray[n2].signum() <= 0) continue;
                bigIntegerArray[n2] = bigInteger2;
            }
        }
        assert (bigIntegerArray[n].signum() > 0);
        assert (bigInteger.compareTo(bigInteger2) > 0);
        return bigInteger2;
    }

    private boolean positiveCoefs(BigInteger[] bigIntegerArray) {
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            if (bigIntegerArray[i].signum() > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getBacktrackLevel(int n) {
        int n2;
        int n3 = ConflictMap.levelToIndex(n) - 1;
        int n4 = ConflictMap.levelToIndex(0);
        BigInteger bigInteger = this.computeSlack(0).subtract(this.degree);
        int n5 = 0;
        for (n2 = n4; n2 <= n3; ++n2) {
            if (this.byLevel[n2] == null) continue;
            int n6 = ConflictMap.indexToLevel(n2);
            assert (this.computeSlack(n6).subtract(this.degree).equals(bigInteger));
            if (this.isImplyingLiteral(n6, bigInteger)) break;
            VecInt vecInt = this.byLevel[n2];
            for (Integer n7 : vecInt) {
                if (!this.voc.isFalsified(n7) || this.voc.getLevel(n7) != ConflictMap.indexToLevel(n2)) continue;
                bigInteger = bigInteger.subtract((BigInteger)this.coefs.get(n7));
            }
            if (vecInt.isEmpty()) continue;
            n5 = n6;
        }
        n2 = this.oldGetBacktrackLevel(n);
        assert (n5 == n2);
        return n5;
    }

    public int oldGetBacktrackLevel(int n) {
        int n2;
        int n3 = n;
        assert (this.oldIsAssertive(n3));
        int n4 = -1;
        Iterator iterator = this.coefs.keySet().iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            n2 = this.voc.getLevel(n5);
            if (n2 >= n3 || n2 <= n4 || !this.oldIsAssertive(n2)) continue;
            n3 = n2;
        }
        int n6 = 0;
        Iterator iterator2 = this.coefs.keySet().iterator();
        while (iterator2.hasNext()) {
            int n7 = (Integer)iterator2.next();
            n2 = this.voc.getLevel(n7);
            if (n2 <= n6 || n2 >= n3) continue;
            n6 = n2;
        }
        return n6;
    }

    @Override
    public void updateSlack(int n) {
        int n2 = ConflictMap.levelToIndex(n);
        if (this.byLevel[n2] != null) {
            for (int n3 : this.byLevel[n2]) {
                if (!this.voc.isFalsified(n3)) continue;
                this.currentSlack = this.currentSlack.add((BigInteger)this.coefs.get(n3));
            }
        }
    }

    @Override
    void increaseCoef(Integer n, BigInteger bigInteger) {
        int n2 = n;
        if (!this.voc.isFalsified(n2) || this.voc.getLevel(n2) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n2))].contains(n2));
        super.increaseCoef(n, bigInteger);
    }

    @Override
    void decreaseCoef(Integer n, BigInteger bigInteger) {
        int n2 = n;
        if (!this.voc.isFalsified(n2) || this.voc.getLevel(n2) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n2))].contains(n2));
        super.decreaseCoef(n, bigInteger);
    }

    @Override
    void setCoef(Integer n, BigInteger bigInteger) {
        int n2 = n;
        int n3 = this.voc.getLevel(n2);
        if (!this.voc.isFalsified(n2) || n3 == this.currentLevel) {
            if (this.coefs.containsKey(n)) {
                this.currentSlack = this.currentSlack.subtract((BigInteger)this.coefs.get(n));
            }
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        int n4 = ConflictMap.levelToIndex(n3);
        if (!this.coefs.containsKey(n)) {
            if (this.byLevel[n4] == null) {
                this.byLevel[n4] = new VecInt();
            }
            this.byLevel[n4].push(n2);
        }
        assert (this.byLevel[n4] != null);
        assert (this.byLevel[n4].contains(n2));
        super.setCoef(n, bigInteger);
    }

    @Override
    void removeCoef(Integer n) {
        int n2 = n;
        int n3 = this.voc.getLevel(n2);
        if (!this.voc.isFalsified(n2) || n3 == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract((BigInteger)this.coefs.get(n));
        }
        int n4 = ConflictMap.levelToIndex(n3);
        assert (n4 < this.byLevel.length);
        assert (this.byLevel[n4] != null);
        assert (this.byLevel[n4].contains(n2));
        this.byLevel[n4].remove(n);
        super.removeCoef(n);
    }

    private int getLevelByLevel(int n) {
        for (int i = 0; i < this.byLevel.length; ++i) {
            if (this.byLevel[i] == null || !this.byLevel[i].contains(n)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : this.coefs.entrySet()) {
            int n = (Integer)entry.getKey();
            stringBuilder.append(entry.getValue());
            stringBuilder.append(".");
            stringBuilder.append(Lits.toString(n));
            stringBuilder.append(" ");
            stringBuilder.append("[");
            stringBuilder.append(this.voc.valueToString(n));
            stringBuilder.append("@");
            stringBuilder.append(this.voc.getLevel(n));
            stringBuilder.append("]");
        }
        return stringBuilder.toString() + " >= " + this.degree;
    }
}

