/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.constraints.pb.ConflictMap;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;

public class ConflictMapClause
extends ConflictMap {
    public ConflictMapClause(Map<Integer, BigInteger> map, BigInteger bigInteger, ILits iLits, int n) {
        super(map, bigInteger, iLits, n);
    }

    public static IConflict createConflict(PBConstr pBConstr, int n) {
        HashMap<Integer, BigInteger> hashMap = new HashMap<Integer, BigInteger>();
        for (int i = 0; i < pBConstr.size(); ++i) {
            int n2 = pBConstr.get(i);
            BigInteger bigInteger = pBConstr.getCoef(i);
            assert (pBConstr.get(i) != 0);
            assert (pBConstr.getCoef(i).signum() > 0);
            hashMap.put(n2, bigInteger);
        }
        return new ConflictMapClause(hashMap, pBConstr.getDegree(), pBConstr.getVocabulary(), n);
    }

    @Override
    protected BigInteger reduceUntilConflict(int n, int n2, BigInteger[] bigIntegerArray, WatchPb watchPb) {
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            bigIntegerArray[i] = i == n2 || watchPb.getVocabulary().isFalsified(watchPb.get(i)) ? BigInteger.ONE : BigInteger.ZERO;
        }
        this.coefMultCons = (BigInteger)this.coefs.get(n ^ 1);
        this.coefMult = BigInteger.ONE;
        return BigInteger.ONE;
    }
}

