/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class MapPb
implements IDataStructurePB {
    protected Map<Integer, BigInteger> coefs;
    protected BigInteger degree;

    MapPb(Map<Integer, BigInteger> map, BigInteger bigInteger) {
        this.coefs = map;
        this.degree = bigInteger;
    }

    MapPb(ILits iLits) {
        this();
    }

    MapPb() {
        this(new HashMap<Integer, BigInteger>(), BigInteger.ZERO);
    }

    @Override
    public BigInteger saturation() {
        assert (this.degree.signum() > 0);
        BigInteger bigInteger = this.degree;
        for (Map.Entry<Integer, BigInteger> object : this.coefs.entrySet()) {
            assert (object.getValue().signum() > 0);
            if (this.degree.compareTo(object.getValue()) < 0) {
                this.setCoef(object.getKey(), this.degree);
            }
            assert (object.getValue().signum() > 0);
            bigInteger = bigInteger.min(object.getValue());
        }
        if (bigInteger.equals(this.degree) && bigInteger.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            for (Integer n : this.coefs.keySet()) {
                this.setCoef(n, BigInteger.ONE);
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr pBConstr, BigInteger bigInteger, BigInteger[] bigIntegerArray, VarActivityListener varActivityListener) {
        return this.cuttingPlane(pBConstr, bigInteger, bigIntegerArray, BigInteger.ONE, varActivityListener);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr pBConstr, BigInteger bigInteger, BigInteger[] bigIntegerArray, BigInteger bigInteger2, VarActivityListener varActivityListener) {
        this.degree = this.degree.add(bigInteger);
        assert (this.degree.signum() > 0);
        if (bigIntegerArray == null) {
            for (int i = 0; i < pBConstr.size(); ++i) {
                varActivityListener.varBumpActivity(pBConstr.get(i));
                this.cuttingPlaneStep(pBConstr.get(i), this.multiplyCoefficient(pBConstr.getCoef(i), bigInteger2));
            }
        } else {
            for (int i = 0; i < pBConstr.size(); ++i) {
                varActivityListener.varBumpActivity(pBConstr.get(i));
                this.cuttingPlaneStep(pBConstr.get(i), this.multiplyCoefficient(bigIntegerArray[i], bigInteger2));
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.cuttingPlane(nArray, bigIntegerArray, bigInteger, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        this.degree = this.degree.add(bigInteger);
        assert (this.degree.signum() > 0);
        for (int i = 0; i < nArray.length; ++i) {
            this.cuttingPlaneStep(nArray[i], bigIntegerArray[i].multiply(bigInteger2));
        }
        return this.degree;
    }

    private void cuttingPlaneStep(int n, BigInteger bigInteger) {
        assert (bigInteger.signum() >= 0);
        Integer n2 = n;
        Integer n3 = n ^ 1;
        if (bigInteger.signum() > 0) {
            if (this.coefs.containsKey(n3)) {
                assert (!this.coefs.containsKey(n2));
                if (this.coefs.get(n3).compareTo(bigInteger) < 0) {
                    BigInteger bigInteger2 = this.coefs.get(n3);
                    this.setCoef(n2, bigInteger.subtract(bigInteger2));
                    assert (this.coefs.get(n2).signum() > 0);
                    this.degree = this.degree.subtract(bigInteger2);
                    this.removeCoef(n3);
                } else if (this.coefs.get(n3).equals(bigInteger)) {
                    this.degree = this.degree.subtract(bigInteger);
                    this.removeCoef(n3);
                } else {
                    this.decreaseCoef(n3, bigInteger);
                    assert (this.coefs.get(n3).signum() > 0);
                    this.degree = this.degree.subtract(bigInteger);
                }
            } else {
                assert (!this.coefs.containsKey(n2) || this.coefs.get(n2).signum() > 0);
                if (this.coefs.containsKey(n2)) {
                    this.increaseCoef(n2, bigInteger);
                } else {
                    this.setCoef(n2, bigInteger);
                }
                assert (this.coefs.get(n2).signum() > 0);
            }
        }
        assert (!this.coefs.containsKey(n3) || !this.coefs.containsKey(n2));
    }

    @Override
    public void buildConstraintFromConflict(IVecInt iVecInt, IVec<BigInteger> iVec) {
        iVecInt.clear();
        iVec.clear();
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            iVecInt.push(entry.getKey());
            assert (entry.getValue().signum() > 0);
            iVec.push(entry.getValue());
        }
    }

    @Override
    public void buildConstraintFromMapPb(int[] nArray, BigInteger[] bigIntegerArray) {
        assert (nArray.length == bigIntegerArray.length);
        assert (nArray.length == this.coefs.keySet().size());
        int n = 0;
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            nArray[n] = entry.getKey();
            assert (entry.getValue().signum() > 0);
            bigIntegerArray[n] = entry.getValue();
            ++n;
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        return this.coefs.keySet().size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Integer, BigInteger> entry : this.coefs.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(".");
            stringBuilder.append(Lits.toString(entry.getKey()));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString() + " >= " + this.degree;
    }

    private BigInteger multiplyCoefficient(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return bigInteger2;
        }
        return bigInteger.multiply(bigInteger2);
    }

    void increaseCoef(Integer n, BigInteger bigInteger) {
        this.coefs.put(n, this.coefs.get(n).add(bigInteger));
    }

    void decreaseCoef(Integer n, BigInteger bigInteger) {
        this.coefs.put(n, this.coefs.get(n).subtract(bigInteger));
    }

    void setCoef(Integer n, BigInteger bigInteger) {
        this.coefs.put(n, bigInteger);
    }

    void removeCoef(Integer n) {
        this.coefs.remove(n);
    }
}

