/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class MaxWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;

    private MaxWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.equals(BigInteger.ZERO));
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) {
                if (!this.learnt) continue;
                this.voc.undos(this.lits[i] ^ 1).push(this);
                continue;
            }
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    @Override
    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.coefs.length && this.watchCumul.subtract(this.coefs[i]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return MaxWatchPb.maxWatchPbNew(unitPropagationListener, iLits, iVecInt, MaxWatchPb.toVecBigInt(iVecInt2), bl, MaxWatchPb.toBigInt(n));
    }

    public static MaxWatchPb maxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        VecInt vecInt = new VecInt();
        Vec<BigInteger> vec = new Vec<BigInteger>();
        iVecInt.copyTo(vecInt);
        iVec.copyTo(vec);
        IDataStructurePB iDataStructurePB = MaxWatchPb.niceParameters(vecInt, vec, bl, bigInteger, iLits);
        if (iDataStructurePB == null) {
            return null;
        }
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, iDataStructurePB);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }

    @Override
    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0) : "" + this.watchCumul + "/" + this.recalcLeftSide() + ":" + this.learnt;
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        BigInteger bigInteger = this.coefs[n2];
        BigInteger bigInteger2 = this.watchCumul.subtract(bigInteger);
        if (bigInteger2.compareTo(this.degree) < 0) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(n).push(this);
        this.watchCumul = bigInteger2;
        BigInteger bigInteger3 = this.watchCumul.subtract(this.degree);
        for (int i = 0; i < this.coefs.length && bigInteger3.compareTo(this.coefs[i]) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            assert (!this.isSatisfiable());
            return false;
        }
        assert (this.learnt || this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        assert (this.watchCumul.compareTo(this.recalcLeftSide()) >= 0);
        return true;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watches(this.lits[i] ^ 1).remove(this);
        }
    }

    @Override
    public void undo(int n) {
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (this.coefs[n2].signum() > 0);
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) {
        return MaxWatchPb.watchPbNew(iLits, iVecInt, MaxWatchPb.toVecBigInt(iVecInt2), bl, MaxWatchPb.toBigInt(n));
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        IDataStructurePB iDataStructurePB = null;
        iDataStructurePB = MaxWatchPb.niceCheckedParameters(iVecInt, iVec, bl, bigInteger, iLits);
        return new MaxWatchPb(iLits, iDataStructurePB);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IDataStructurePB iDataStructurePB) throws ContradictionException {
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, iDataStructurePB);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }
}

