/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class MinWatchPb
extends WatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.locked = false;
        this.watchingCount = 0;
    }

    @Override
    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.signum() == 0);
        assert (this.watchingCount == 0);
        for (int i = 0; i < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watching[this.watchingCount++] = i;
            this.watched[i] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[i]);
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this.lits.length; ++i) {
                if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                ++n;
                int n4 = this.voc.getLevel(this.lits[i]);
                if (n4 <= n2) continue;
                n3 = i;
                n2 = n4;
            }
            if (n <= 0) continue;
            assert (n3 >= 0);
            this.voc.watch(this.lits[n3] ^ 1, this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[n3]);
            assert (--n >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    @Override
    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[i]]).compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return MinWatchPb.minWatchPbNew(unitPropagationListener, iLits, iVecInt, MinWatchPb.toVecBigInt(iVecInt2), bl, MinWatchPb.toBigInt(n));
    }

    public static MinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size());
        Vec<BigInteger> vec = new Vec<BigInteger>(iVec.size());
        iVecInt.copyTo(vecInt);
        iVec.copyTo(vec);
        IDataStructurePB iDataStructurePB = MinWatchPb.niceParameters(vecInt, vec, bl, bigInteger, iLits);
        if (iDataStructurePB == null) {
            return null;
        }
        MinWatchPb minWatchPb = new MinWatchPb(iLits, iDataStructurePB);
        if (minWatchPb.degree.signum() <= 0) {
            return null;
        }
        minWatchPb.computeWatches();
        minWatchPb.computePropagation(unitPropagationListener);
        return minWatchPb;
    }

    public static MinWatchPb normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IDataStructurePB iDataStructurePB) throws ContradictionException {
        MinWatchPb minWatchPb = new MinWatchPb(iLits, iDataStructurePB);
        if (minWatchPb.degree.signum() <= 0) {
            return null;
        }
        minWatchPb.computeWatches();
        minWatchPb.computePropagation(unitPropagationListener);
        return minWatchPb;
    }

    protected int nbOfWatched() {
        int n = 0;
        for (int i = 0; i < this.watched.length; ++i) {
            for (int j = 0; j < this.watchingCount; ++j) {
                if (this.watching[j] == i) assert (this.watched[i]);
            }
            n += this.watched[i] ? 1 : 0;
        }
        return n;
    }

    @Override
    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        for (n2 = 0; n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n; ++n2) {
        }
        int n3 = this.watching[n2];
        assert (n == (this.lits[n3] ^ 1));
        assert (this.watched[n3]);
        BigInteger bigInteger = this.maximalCoefficient(n3);
        bigInteger = this.updateWatched(bigInteger, n3);
        BigInteger bigInteger2 = this.watchCumul.subtract(this.coefs[n3]);
        assert (this.nbOfWatched() == this.watchingCount);
        if (bigInteger2.compareTo(this.degree) < 0) {
            this.voc.watch(n, this);
            assert (this.watched[n3]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (bigInteger2.compareTo(this.degree.add(bigInteger)) < 0) {
            assert (this.watchingCount != 0);
            BigInteger bigInteger3 = bigInteger2.subtract(this.degree);
            for (int i = 0; i < this.watchingCount; ++i) {
                if (bigInteger3.compareTo(this.coefs[this.watching[i]]) >= 0 || i == n2 || this.voc.isSatisfied(this.lits[this.watching[i]]) || unitPropagationListener.enqueue(this.lits[this.watching[i]], this)) continue;
                this.voc.watch(n, this);
                assert (!this.isSatisfiable());
                return false;
            }
            this.voc.undos(n).push(this);
        }
        this.watched[n3] = false;
        this.watchCumul = bigInteger2;
        this.watching[n2] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    @Override
    public void remove() {
        for (int i = 0; i < this.watchingCount; ++i) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    @Override
    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (n2 < this.lits.length);
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) {
        return MinWatchPb.watchPbNew(iLits, iVecInt, MinWatchPb.toVecBigInt(iVecInt2), bl, MinWatchPb.toBigInt(n));
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        IDataStructurePB iDataStructurePB = null;
        iDataStructurePB = MinWatchPb.niceCheckedParameters(iVecInt, iVec, bl, bigInteger, iLits);
        return new MinWatchPb(iLits, iDataStructurePB);
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) throws ContradictionException {
        return new MinWatchPb(iLits, iDataStructurePB);
    }

    protected BigInteger maximalCoefficient(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.watchingCount; ++i) {
            if (this.coefs[this.watching[i]].compareTo(bigInteger) <= 0 || this.watching[i] == n) continue;
            bigInteger = this.coefs[this.watching[i]];
        }
        assert (this.learnt || bigInteger.signum() != 0);
        return bigInteger;
    }

    protected BigInteger updateWatched(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger;
        if (this.watchingCount < this.size()) {
            BigInteger bigInteger3 = this.watchCumul.subtract(this.coefs[n]);
            BigInteger bigInteger4 = this.degree.add(bigInteger2);
            for (int i = 0; i < this.lits.length && bigInteger3.compareTo(bigInteger4) < 0; ++i) {
                if (this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                bigInteger3 = bigInteger3.add(this.coefs[i]);
                this.watched[i] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = i;
                this.voc.watch(this.lits[i] ^ 1, this);
                if (this.coefs[i].compareTo(bigInteger2) <= 0) continue;
                bigInteger2 = this.coefs[i];
                bigInteger4 = this.degree.add(bigInteger2);
            }
            this.watchCumul = bigInteger3.add(this.coefs[n]);
        }
        return bigInteger2;
    }
}

