/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.ConflictMap;
import org.sat4j.minisat.constraints.pb.IConflict;
import org.sat4j.minisat.constraints.pb.PBConstr;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.Handle;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.IVecInt;

public class PBSolver
extends Solver {
    private static final long serialVersionUID = 1L;

    public PBSolver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy learningStrategy, DataStructureFactory dataStructureFactory, IOrder iOrder) {
        super(assertingClauseGenerator, learningStrategy, dataStructureFactory, new SearchParams(10000.0, 100), iOrder);
    }

    @Override
    public int analyze(Constr constr, Handle<Constr> handle) {
        Object object;
        int n = this.trail.last();
        int n2 = this.voc.getLevel(n);
        IConflict iConflict = this.chooseConflict(constr, n2);
        BigInteger bigInteger = iConflict.getDegree();
        assert (iConflict.slackConflict().signum() < 0);
        while (!iConflict.isAssertive(n2)) {
            object = (PBConstr)this.voc.getReason(n);
            if (object != null) {
                bigInteger = iConflict.resolve((PBConstr)object, n, this);
                assert (iConflict.slackConflict().signum() <= 0);
            }
            if (this.trail.size() == 1) break;
            this.undoOne();
            assert (this.decisionLevel() > 0);
            n = this.trail.last();
            if (this.voc.getLevel(n) != n2) {
                this.trailLim.pop();
                iConflict.updateSlack(this.voc.getLevel(n));
            }
            assert (this.voc.getLevel(n) <= n2);
            n2 = this.voc.getLevel(n);
            assert (n2 == this.decisionLevel());
            assert (n > 1);
        }
        assert (n2 == this.decisionLevel());
        assert (this.decisionLevel() != 0);
        this.undoOne();
        object = new VecInt();
        Vec<BigInteger> vec = new Vec<BigInteger>();
        iConflict.buildConstraintFromConflict((IVecInt)object, vec);
        assert (object.size() == vec.size());
        if (object.size() == 0) {
            handle.obj = null;
            return -1;
        }
        PBConstr pBConstr = (PBConstr)this.dsfactory.createUnregisteredPseudoBooleanConstraint((IVecInt)object, vec, bigInteger);
        handle.obj = pBConstr;
        assert (iConflict.isAssertive(n2));
        return iConflict.getBacktrackLevel(n2);
    }

    IConflict chooseConflict(Constr constr, int n) {
        return ConflictMap.createConflict((PBConstr)constr, n);
    }

    @Override
    public String toString(String string) {
        return string + "Cutting planes based inference (" + this.getClass().getName() + ")\n" + super.toString(string);
    }
}

