/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.pb.IDataStructurePB;
import org.sat4j.minisat.constraints.pb.MinWatchPb;
import org.sat4j.minisat.constraints.pb.WatchPb;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class PuebloMinWatchPb
extends MinWatchPb
implements Serializable {
    private static final long serialVersionUID = 1L;

    private PuebloMinWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iLits, iDataStructurePB);
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) throws ContradictionException {
        return PuebloMinWatchPb.minWatchPbNew(unitPropagationListener, iLits, iVecInt, PuebloMinWatchPb.toVecBigInt(iVecInt2), bl, PuebloMinWatchPb.toBigInt(n));
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size());
        Vec<BigInteger> vec = new Vec<BigInteger>(iVec.size());
        iVecInt.copyTo(vecInt);
        iVec.copyTo(vec);
        IDataStructurePB iDataStructurePB = PuebloMinWatchPb.niceParameters(vecInt, vec, bl, bigInteger, iLits);
        PuebloMinWatchPb puebloMinWatchPb = new PuebloMinWatchPb(iLits, iDataStructurePB);
        if (puebloMinWatchPb.degree.signum() <= 0) {
            return null;
        }
        puebloMinWatchPb.computeWatches();
        puebloMinWatchPb.computePropagation(unitPropagationListener);
        return puebloMinWatchPb;
    }

    public static PuebloMinWatchPb minWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, IDataStructurePB iDataStructurePB) throws ContradictionException {
        PuebloMinWatchPb puebloMinWatchPb = new PuebloMinWatchPb(iLits, iDataStructurePB);
        if (puebloMinWatchPb.degree.signum() <= 0) {
            return null;
        }
        puebloMinWatchPb.computeWatches();
        puebloMinWatchPb.computePropagation(unitPropagationListener);
        return puebloMinWatchPb;
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVecInt iVecInt2, boolean bl, int n) {
        return PuebloMinWatchPb.watchPbNew(iLits, iVecInt, PuebloMinWatchPb.toVecBigInt(iVecInt2), bl, PuebloMinWatchPb.toBigInt(n));
    }

    public static WatchPb watchPbNew(ILits iLits, IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) {
        IDataStructurePB iDataStructurePB = null;
        iDataStructurePB = PuebloMinWatchPb.niceCheckedParameters(iVecInt, iVec, bl, bigInteger, iLits);
        return new PuebloMinWatchPb(iLits, iDataStructurePB);
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new PuebloMinWatchPb(iLits, iDataStructurePB);
    }

    @Override
    protected BigInteger maximalCoefficient(int n) {
        return this.coefs[0];
    }

    @Override
    protected BigInteger updateWatched(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger;
        if (this.watchingCount < this.size()) {
            BigInteger bigInteger3 = this.watchCumul.subtract(this.coefs[n]);
            BigInteger bigInteger4 = this.degree.add(bigInteger2);
            for (int i = 0; i < this.lits.length && bigInteger3.compareTo(bigInteger4) < 0; ++i) {
                if (this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                bigInteger3 = bigInteger3.add(this.coefs[i]);
                this.watched[i] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = i;
                this.voc.watch(this.lits[i] ^ 1, this);
            }
            this.watchCumul = bigInteger3.add(this.coefs[n]);
        }
        return bigInteger2;
    }
}

