/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.SearchListener;

public class DotSearchListener
implements SearchListener {
    private static final long serialVersionUID = 1L;
    private final transient Stack<String> pile = new Stack();
    private transient String currentNodeName = null;
    private transient Writer out;
    private transient boolean estOrange = false;

    public DotSearchListener(String string) {
        try {
            this.out = new FileWriter(string);
        }
        catch (IOException iOException) {
            System.err.println("Problem when created file.");
        }
    }

    @Override
    public final void assuming(int n) {
        String string;
        Integer n2 = Math.abs(n);
        if (this.currentNodeName == null) {
            string = n2.toString();
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + string + "\", shape=circle, color=blue, style=filled]"));
        } else {
            string = this.currentNodeName;
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + n2.toString() + "\", shape=circle, color=blue, style=filled]"));
        }
        this.currentNodeName = string;
    }

    @Override
    public final void propagating(int n) {
        String string = this.currentNodeName + "." + n;
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String string2 = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + Integer.toString(n) + "\",shape=point, color=black]"));
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\"" + " -- " + "\"" + string + "\"" + "[label=" + "\" " + Integer.toString(n) + "\", fontcolor =" + string2 + ", color = " + string2 + ", style = bold]"));
        this.currentNodeName = string;
        this.estOrange = false;
    }

    @Override
    public final void backtracking(int n) {
        String string = this.pile.pop();
        this.saveLine("\"" + string + "\"" + "--" + "\"" + this.currentNodeName + "\"" + "[label=\"\", color=red, style=dotted]");
        this.currentNodeName = string;
    }

    @Override
    public final void adding(int n) {
        this.estOrange = true;
    }

    @Override
    public final void learn(Constr constr) {
    }

    @Override
    public final void delete(int[] nArray) {
    }

    @Override
    public final void conflictFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    @Override
    public final void solutionFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"green\", style=filled]"));
    }

    @Override
    public final void beginLoop() {
    }

    @Override
    public final void start() {
        this.saveLine("graph G {");
    }

    @Override
    public final void end(Lbool lbool) {
        this.saveLine("}");
    }

    private final String lineTab(String string) {
        return "\t" + string;
    }

    private final void saveLine(String string) {
        try {
            this.out.write(string + '\n');
            if ("}".equals(string)) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

