/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.LimitedLearning;

public class ActiveLearning
extends LimitedLearning {
    private static final long serialVersionUID = 1L;
    private double percent;
    private IOrder order;

    public ActiveLearning() {
        this(0.95);
    }

    public ActiveLearning(double d) {
        this.percent = d;
    }

    public void setOrder(IOrder iOrder) {
        this.order = iOrder;
    }

    @Override
    public void setSolver(Solver solver) {
        super.setSolver(solver);
        this.order = solver.getOrder();
    }

    public void setActivityPercent(double d) {
        this.percent = d;
    }

    public double getActivityPercent() {
        return this.percent;
    }

    @Override
    protected boolean learningCondition(Constr constr) {
        int n = 0;
        for (int i = 0; i < constr.size(); ++i) {
            if (!(this.order.varActivity(constr.get(i)) > 1.0)) continue;
            ++n;
        }
        return (double)n > (double)constr.size() * this.percent;
    }

    @Override
    public String toString() {
        return "Limit learning to clauses containing active literals (" + this.percent * 100.0 + "%)";
    }
}

