/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

public class LimitedLearning
implements LearningStrategy {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics none;
    private final MiniSATLearning all;
    private int maxpercent;
    private ILits lits;
    private int bound;

    public LimitedLearning() {
        this(10);
    }

    public LimitedLearning(int n) {
        this.maxpercent = n;
        this.none = new NoLearningButHeuristics();
        this.all = new MiniSATLearning();
    }

    public void setLimit(int n) {
        this.maxpercent = n;
    }

    public int getLimit() {
        return this.maxpercent;
    }

    @Override
    public void setSolver(Solver solver) {
        this.lits = solver.getVocabulary();
        this.setVarActivityListener(solver);
        this.all.setDataStructureFactory(solver.getDSFactory());
    }

    @Override
    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
        }
    }

    protected boolean learningCondition(Constr constr) {
        return constr.size() <= this.bound;
    }

    @Override
    public void init() {
        this.setBound(this.lits.realnVars() * this.maxpercent / 100);
        this.all.init();
        this.none.init();
    }

    protected void setBound(int n) {
        this.bound = n;
    }

    public String toString() {
        return "Limit learning to clauses of size smaller or equal to " + this.maxpercent + "% of the number of variables";
    }

    @Override
    public void setVarActivityListener(VarActivityListener varActivityListener) {
        this.none.setVarActivityListener(varActivityListener);
        this.all.setVarActivityListener(varActivityListener);
    }
}

