/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.orders.VarOrder;

public class MyOrder
extends VarOrder {
    private static final long serialVersionUID = 1L;
    private ILits2 lits;

    @Override
    public void setLits(ILits iLits) {
        super.setLits(iLits);
        this.lits = (ILits2)iLits;
    }

    @Override
    public void init() {
        Temp temp;
        int n;
        super.init();
        ArrayList<Temp> arrayList = new ArrayList<Temp>(this.order.length);
        for (n = 1; n < this.order.length; ++n) {
            temp = new Temp(this.order[n]);
            arrayList.add(temp);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            temp = (Temp)arrayList.get(n);
            this.order[n + 1] = temp.id;
            int n2 = temp.id >> 1;
            this.varpos[n2] = n + 1;
        }
        this.lastVar = 1;
    }

    @Override
    public String toString() {
        return "Init VSIDS order using a POSIT-like static order on 2 and 3 clauses.";
    }

    class Temp
    implements Comparable<Temp> {
        private final int id;
        private final int count;

        Temp(int n) {
            this.id = n;
            this.count = MyOrder.this.lits.nBinaryClauses(n) + MyOrder.this.lits.nBinaryClauses(n ^ 1);
        }

        @Override
        public int compareTo(Temp temp) {
            if (this.count == 0) {
                return Integer.MAX_VALUE;
            }
            if (temp.count == 0) {
                return -1;
            }
            return this.count - temp.count;
        }

        public String toString() {
            return "" + this.id + "(" + this.count + ")";
        }
    }
}

