/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.math.BigInteger;
import org.sat4j.minisat.core.LiteralsUtils;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class VarOrderHeapObjective
extends VarOrderHeap {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction obj;

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    @Override
    public void init() {
        super.init();
        if (this.obj != null) {
            IVecInt iVecInt = this.obj.getVars();
            IVec<BigInteger> iVec = this.obj.getCoeffs();
            for (int i = 0; i < iVecInt.size(); ++i) {
                int n = this.lits.getFromPool(iVecInt.get(i));
                BigInteger bigInteger = iVec.get(i);
                if (bigInteger.signum() < 0) {
                    n = LiteralsUtils.neg(n);
                }
                int n2 = LiteralsUtils.var(n);
                this.activity[n2] = bigInteger.abs().doubleValue();
                if (this.heap.inHeap(n2)) {
                    this.heap.increase(n2);
                }
                this.phase[n2] = LiteralsUtils.neg(n);
            }
        }
    }
}

