/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public abstract class AbstractSelectorVariablesDecorator
extends SolverDecorator {
    protected int nborigvars;
    private int nbexpectedclauses;
    protected int nbnewvar;
    protected int[] prevfullmodel;

    public AbstractSelectorVariablesDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public int[] model() {
        int n = this.nborigvars - 1;
        while (Math.abs(this.prevfullmodel[n]) > this.nborigvars) {
            --n;
        }
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = this.prevfullmodel[i];
        }
        return nArray;
    }

    @Override
    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    @Override
    public void reset() {
        super.reset();
        this.nbnewvar = 0;
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable();
        if (bl) {
            this.prevfullmodel = super.model();
        }
        return bl;
    }
}

